package models

import (
	proto "a.yandex-team.ru/travel/proto"
	"a.yandex-team.ru/travel/proto/dicts/rasp"

	seopb "a.yandex-team.ru/travel/trains/search_api/api/seo_direction"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/points"
)

type SeoDirectionData struct {
	FromPoint           points.Point
	ToPoint             points.Point
	FromCity            *rasp.TSettlement
	ToCity              *rasp.TSettlement
	FromStation         *rasp.TStation
	ToStation           *rasp.TStation
	Status              seopb.SeoDirectionResponseStatus
	FromStationsTitles  []string
	ToStationsTitles    []string
	FirstTrainDeparture string
	LastTrainDeparture  string
	TrainsCount         int
	TrainsStr           string
	AboutTrainsStr      string
	FirmTrainsStr       string
	FirmTrains          []string
	ExpressTrainsStr    string
	ExpressTrains       []string
	PricesByCarType     []*CarTypePrices // sorted by price asc
	TripRangeKm         int
	HasCompartment      bool
	HasPlatzkarte       bool
	ActualYear          int
	SearchDate          string
	MinTripTime         string
	MaxTripTime         string
}

type CarTypePrices struct {
	RawCarType        string
	CarTypeLocative   string
	CarTypeAccusative string
	MinPricePretty    string
	MinPrice          *proto.TPrice
}
