package app

import (
	"a.yandex-team.ru/travel/trains/search_api/internal/direction"
	"a.yandex-team.ru/travel/trains/search_api/internal/pkg/i18n"
	"a.yandex-team.ru/travel/trains/search_api/internal/seo"
)

type Config struct {
	Direction direction.Config
	I18n      i18n.Config
	Seo       seo.Config

	TankerBaseURL    string `config:"tanker-base-url, required" yaml:"tanker-base-url"`
	TankerBranch     string `config:"tanker-branch, required" yaml:"tanker-branch"`
	TankerOAuthToken string `config:"tanker-oauth-token, required" yaml:"tanker-oauth-token"`
	SkipChecks       bool   `config:"skip-checks" yaml:"skip-checks"`
	SkipDump         bool   `config:"skip-dump" yaml:"skip-dump"`
}

var DefaultConfig = Config{
	Direction: direction.DefaultConfig,
	Seo:       seo.DefaultConfig,

	I18n: i18n.Config{
		KeysetPath:      "docker/search_api/keysets/direction.json",
		KeysetMonthPath: "docker/search_api/keysets/months.json",
	},

	TankerBaseURL: "https://tanker-beta.yandex-team.ru/",
	SkipChecks:    false,
	SkipDump:      false,
}
