package balancer

import (
	"context"
	"time"

	"google.golang.org/grpc"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/travel/library/go/grpcutil/client/ypresolver"
)

func CreateConnection(yPlannerID string, logger log.Logger) (*grpc.ClientConn, error) {
	ctx := context.Background()
	ctx, cancel := context.WithTimeout(ctx, 60*time.Second)
	defer cancel()

	return grpc.DialContext(
		ctx,
		ypresolver.BuildServiceFQDN(yPlannerID),
		grpc.WithResolvers(ypresolver.NewYPResolverBuilder(ypresolver.WithLogger(logger.Structured()))),
		grpc.WithDefaultServiceConfig(`{"loadBalancingPolicy":"healthcheck_balancer", "healthCheckConfig": {"serviceName": "worker"}}`),
		grpc.WithDisableHealthCheck(),
		grpc.WithInsecure(),
		//grpc.WithBlock(),
	)
}
