package models

type SearchTrainPricingRequest struct {
	Origin         string `json:"Origin"`
	Destination    string `json:"Destination"`
	DepartureDate  string `json:"DepartureDate"`
	TimeFrom       int    `json:"TimeFrom"`
	TimeTo         int    `json:"TimeTo"`
	GetByLocalTime bool   `json:"GetByLocalTime"`
}

type CarGroup struct {
	MinPrice                         float64       `json:"MinPrice"`
	MaxPrice                         float64       `json:"MaxPrice"`
	Carriers                         []string      `json:"Carriers"`
	CarrierDisplayNames              interface{}   `json:"CarrierDisplayNames"`
	ServiceClasses                   []string      `json:"ServiceClasses"`
	BoardingSystemTypes              interface{}   `json:"BoardingSystemTypes"`
	HasPlacesForDisabledPersons      bool          `json:"HasPlacesForDisabledPersons"`
	BonusInfo                        interface{}   `json:"BonusInfo"`
	CarType                          string        `json:"CarType"`
	CarTypeName                      string        `json:"CarTypeName"`
	PlaceQuantity                    int           `json:"PlaceQuantity"`
	LowerPlaceQuantity               int           `json:"LowerPlaceQuantity"`
	UpperPlaceQuantity               int           `json:"UpperPlaceQuantity"`
	LowerSidePlaceQuantity           int           `json:"LowerSidePlaceQuantity"`
	UpperSidePlaceQuantity           int           `json:"UpperSidePlaceQuantity"`
	MalePlaceQuantity                int           `json:"MalePlaceQuantity"`
	FemalePlaceQuantity              int           `json:"FemalePlaceQuantity"`
	EmptyCabinQuantity               int           `json:"EmptyCabinQuantity"`
	MixedCabinQuantity               int           `json:"MixedCabinQuantity"`
	IsSaleForbidden                  bool          `json:"IsSaleForbidden"`
	AvailabilityIndication           string        `json:"AvailabilityIndication"`
	CarDescriptions                  []string      `json:"CarDescriptions"`
	ServiceClassNameRu               *string       `json:"ServiceClassNameRu"`
	ServiceClassNameEn               *string       `json:"ServiceClassNameEn"`
	InternationalServiceClasses      interface{}   `json:"InternationalServiceClasses"`
	ServiceCosts                     []float64     `json:"ServiceCosts"`
	IsBeddingSelectionPossible       bool          `json:"IsBeddingSelectionPossible"`
	HasElectronicRegistration        bool          `json:"HasElectronicRegistration"`
	HasGenderCabins                  bool          `json:"HasGenderCabins"`
	HasPlaceNumeration               bool          `json:"HasPlaceNumeration"`
	HasPlacesNearPlayground          bool          `json:"HasPlacesNearPlayground"`
	HasPlacesNearPets                bool          `json:"HasPlacesNearPets"`
	HasPlacesNearBabies              bool          `json:"HasPlacesNearBabies"`
	AvailableBaggageTypes            interface{}   `json:"AvailableBaggageTypes"`
	HasNonRefundableTariff           bool          `json:"HasNonRefundableTariff"`
	Discounts                        []interface{} `json:"Discounts"`
	InfoRequestSchema                string        `json:"InfoRequestSchema"`
	TotalPlaceQuantity               int           `json:"TotalPlaceQuantity"`
	PlaceReservationTypes            []string      `json:"PlaceReservationTypes"`
	IsThreeHoursReservationAvailable bool          `json:"IsThreeHoursReservationAvailable"`
	IsMealOptionPossible             bool          `json:"IsMealOptionPossible"`
	IsAdditionalMealOptionPossible   bool          `json:"IsAdditionalMealOptionPossible"`
	IsOnRequestMealOptionPossible    bool          `json:"IsOnRequestMealOptionPossible"`
	IsTransitDocumentRequired        bool          `json:"IsTransitDocumentRequired"`
	IsInterstate                     bool          `json:"IsInterstate"`
	ClientFeeCalculation             interface{}   `json:"ClientFeeCalculation"`
	AgentFeeCalculation              interface{}   `json:"AgentFeeCalculation"`
}

type Train struct {
	HasSpecialSaleMode               bool        `json:"HasSpecialSaleMode"`
	CarGroups                        []CarGroup  `json:"CarGroups"`
	HasElectronicRegistration        bool        `json:"HasElectronicRegistration"`
	HasCarTransportationCoaches      bool        `json:"HasCarTransportationCoaches"`
	HasDynamicPricingCars            bool        `json:"HasDynamicPricingCars"`
	HasTwoStoreyCars                 bool        `json:"HasTwoStoreyCars"`
	Carriers                         []string    `json:"Carriers"`
	CarrierDisplayNames              interface{} `json:"CarrierDisplayNames"`
	ID                               int         `json:"ID"`
	IsBranded                        bool        `json:"IsBranded"`
	TrainNumber                      string      `json:"TrainNumber"`
	TrainNumberToGetRoute            string      `json:"TrainNumberToGetRoute"`
	DisplayTrainNumber               string      `json:"DisplayTrainNumber"`
	TrainDescription                 string      `json:"TrainDescription"`
	TrainFrequency                   interface{} `json:"TrainFrequency"`
	TrainName                        string      `json:"TrainName"`
	TransportType                    string      `json:"TransportType"`
	IsCarPricingSupported            bool        `json:"IsCarPricingSupported"`
	OriginName                       string      `json:"OriginName"`
	InitialStationName               interface{} `json:"InitialStationName"`
	OriginStationCode                string      `json:"OriginStationCode"`
	DestinationName                  string      `json:"DestinationName"`
	FinalStationName                 interface{} `json:"FinalStationName"`
	DestinationStationCode           string      `json:"DestinationStationCode"`
	DestinationNames                 []string    `json:"DestinationNames"`
	FinalStationNames                interface{} `json:"FinalStationNames"`
	DepartureDateTime                string      `json:"DepartureDateTime"`
	LocalDepartureDateTime           string      `json:"LocalDepartureDateTime"`
	ArrivalDateTime                  string      `json:"ArrivalDateTime"`
	LocalArrivalDateTime             string      `json:"LocalArrivalDateTime"`
	ArrivalDateTimes                 []string    `json:"ArrivalDateTimes"`
	LocalArrivalDateTimes            []string    `json:"LocalArrivalDateTimes"`
	DepartureDateFromFormingStation  string      `json:"DepartureDateFromFormingStation"`
	DepartureStopTime                int         `json:"DepartureStopTime"`
	ArrivalStopTime                  int         `json:"ArrivalStopTime"`
	TripDuration                     int         `json:"TripDuration"`
	TripDistance                     int         `json:"TripDistance"`
	IsSuburban                       bool        `json:"IsSuburban"`
	IsComponent                      bool        `json:"IsComponent"`
	CarServices                      interface{} `json:"CarServices"`
	IsSaleForbidden                  bool        `json:"IsSaleForbidden"`
	IsTicketPrintRequiredForBoarding bool        `json:"IsTicketPrintRequiredForBoarding"`
	BookingSystem                    string      `json:"BookingSystem"`
	Provider                         string      `json:"Provider"`
	IsVrStorageSystem                bool        `json:"IsVrStorageSystem"`
	BuybackDate                      interface{} `json:"BuybackDate"`
	PlacesStorageType                string      `json:"PlacesStorageType"`
	BoardingSystemTypes              interface{} `json:"BoardingSystemTypes"`
	HasNonRefundableTariff           bool        `json:"HasNonRefundableTariff"`
}

type ClientFeeCalculation struct {
	Charge float64 `json:"Charge"`
	Profit float64 `json:"Profit"`
}

type AgentFeeCalculation struct {
	Charge float64 `json:"Charge"`
	Profit float64 `json:"Profit"`
}

type SearchTrainPricingResponse struct {
	RoutePolicy                   string               `json:"RoutePolicy"`
	OriginStationCode             string               `json:"OriginStationCode"`
	DestinationStationCode        string               `json:"DestinationStationCode"`
	Trains                        []Train              `json:"Trains"`
	ClientFeeCalculation          ClientFeeCalculation `json:"ClientFeeCalculation"`
	AgentFeeCalculation           AgentFeeCalculation  `json:"AgentFeeCalculation"`
	OriginCode                    interface{}          `json:"OriginCode"`
	OriginTimeZoneDifference      int                  `json:"OriginTimeZoneDifference"`
	DestinationCode               interface{}          `json:"DestinationCode"`
	DestinationTimeZoneDifference int                  `json:"DestinationTimeZoneDifference"`
	DepartureTimeDescription      string               `json:"DepartureTimeDescription"`
	ArrivalTimeDescription        string               `json:"ArrivalTimeDescription"`
	IsFromUkrain                  bool                 `json:"IsFromUkrain"`
	NotAllTrainsReturned          bool                 `json:"NotAllTrainsReturned"`
	StationClarifying             interface{}          `json:"StationClarifying"`
	BookingSystem                 string               `json:"BookingSystem"`
	ID                            int                  `json:"ID"`
}

type SearchTrainRouteRequest struct {
	TrainNumber   string `json:"TrainNumber"`
	Origin        string `json:"Origin"`
	Destination   string `json:"Destination"`
	DepartureDate string `json:"DepartureDate"`
	Provider      string `json:"Provider"`
}

type RouteStop struct {
	StationCode                interface{} `json:"StationCode"`
	StationName                string      `json:"StationName"`
	CityName                   string      `json:"CityName"`
	DepartureTime              string      `json:"DepartureTime"`
	ArrivalTime                string      `json:"ArrivalTime"`
	LocalArrivalTime           *string     `json:"LocalArrivalTime"`
	RouteStopType              string      `json:"RouteStopType"`
	StopDuration               int         `json:"StopDuration"`
	DistanceFromInitialStation interface{} `json:"DistanceFromInitialStation"`
	TimeDescription            string      `json:"TimeDescription"`
	LocalDepartureTime         *string     `json:"LocalDepartureTime"`
	DepartureDateTime          *string     `json:"DepartureDateTime"`
	LocalDepartureDateTime     *string     `json:"LocalDepartureDateTime"`
	ArrivalDateTime            *string     `json:"ArrivalDateTime"`
	LocalArrivalDateTime       *string     `json:"LocalArrivalDateTime"`
	Clarification              interface{} `json:"Clarification"`
}

type Route struct {
	RouteStops      []RouteStop `json:"RouteStops"`
	Name            string      `json:"Name"`
	OriginName      string      `json:"OriginName"`
	DestinationName string      `json:"DestinationName"`
}

type SearchTrainRouteResponse struct {
	Routes []Route `json:"Routes"`
}

type SearchScheduleRequest struct {
	Origin        string      `json:"Origin"`
	Destination   string      `json:"Destination"`
	DepartureDate interface{} `json:"DepartureDate"`
	TimeFrom      int         `json:"TimeFrom"`
	TimeTo        int         `json:"TimeTo"`
	Provider      string      `json:"Provider"`
}

type Schedule struct {
	TrainNumber            string      `json:"TrainNumber"`
	TrainNumberToGetRoute  string      `json:"TrainNumberToGetRoute"`
	TrainName              string      `json:"TrainName"`
	OriginName             string      `json:"OriginName"`
	OriginStationCode      string      `json:"OriginStationCode"`
	DestinationName        string      `json:"DestinationName"`
	DestinationStationCode string      `json:"DestinationStationCode"`
	DepartureTime          string      `json:"DepartureTime"`
	LocalDepartureTime     string      `json:"LocalDepartureTime"`
	DepartureStopTime      int         `json:"DepartureStopTime"`
	ArrivalTime            string      `json:"ArrivalTime"`
	LocalArrivalTime       string      `json:"LocalArrivalTime"`
	ArrivalStopTime        int         `json:"ArrivalStopTime"`
	TripDuration           int         `json:"TripDuration"`
	TripDistance           int         `json:"TripDistance"`
	Regularity             string      `json:"Regularity"`
	StartSalesDateTime     interface{} `json:"StartSalesDateTime"`
}

type SearchScheduleResponse struct {
	OriginStationCode             string      `json:"OriginStationCode"`
	DestinationStationCode        string      `json:"DestinationStationCode"`
	RoutePolicy                   string      `json:"RoutePolicy"`
	Schedules                     []Schedule  `json:"Schedules"`
	StationClarifying             interface{} `json:"StationClarifying"`
	OriginTimeZoneDifference      int         `json:"OriginTimeZoneDifference"`
	DestinationTimeZoneDifference int         `json:"DestinationTimeZoneDifference"`
	NotAllTrainsReturned          bool        `json:"NotAllTrainsReturned"`
}

type ReservationElectronicRegistrationRequest struct {
	OrderItemID       int   `json:"OrderItemID"`
	OrderItemBlankIds []int `json:"OrderItemBlankIds"`
	Set               bool  `json:"Set"`
}

type ReservationElectronicRegistrationResponse struct {
	ExpirationElectronicRegistrationDateTime interface{} `json:"ExpirationElectronicRegistrationDateTime"`
	Blanks                                   interface{} `json:"Blanks"`
}

type ReservationUpdateBlanksRequest struct {
	OrderItemID int `json:"OrderItemID"`
}

type Blank struct {
	OrderItemBlankID                         int         `json:"OrderItemBlankID"`
	Number                                   string      `json:"Number"`
	BlankStatus                              string      `json:"BlankStatus"`
	PendingElectronicRegistration            string      `json:"PendingElectronicRegistration"`
	SignSequence                             interface{} `json:"SignSequence"`
	OnlineTicketReturnExpirationDateTime     interface{} `json:"OnlineTicketReturnExpirationDateTime"`
	ElectronicRegistrationExpirationDateTime interface{} `json:"ElectronicRegistrationExpirationDateTime"`
	ElectronicRegistrationSetDateTime        interface{} `json:"ElectronicRegistrationSetDateTime"`
}

type ReservationUpdateBlanksResponse struct {
	Blanks     []Blank `json:"Blanks"`
	IsModified bool    `json:"IsModified"`
}

type SearchCarPricingRequest struct {
	OriginCode                      string      `json:"OriginCode"`
	DestinationCode                 string      `json:"DestinationCode"`
	DepartureDate                   string      `json:"DepartureDate"`
	TrainNumber                     string      `json:"TrainNumber"`
	CarType                         interface{} `json:"CarType"`
	TariffType                      string      `json:"TariffType"`
	SpecialPlacesDemand             string      `json:"SpecialPlacesDemand"`
	GetOnlyCarTransportationCoaches bool        `json:"GetOnlyCarTransportationCoaches"`
	GetOnlyNonRefundableTariffs     bool        `json:"GetOnlyNonRefundableTariffs"`
	Provider                        string      `json:"Provider"`
}

type Car struct {
	DestinationStationCode            interface{}   `json:"DestinationStationCode"`
	CarType                           string        `json:"CarType"`
	RailwayCarSchemeID                interface{}   `json:"RailwayCarSchemeID"`
	CarSubType                        interface{}   `json:"CarSubType"`
	CarTypeName                       string        `json:"CarTypeName"`
	CarSchemeName                     interface{}   `json:"CarSchemeName"`
	CarNumber                         string        `json:"CarNumber"`
	ServiceClass                      string        `json:"ServiceClass"`
	ServiceClassNameRu                string        `json:"ServiceClassNameRu"`
	ServiceClassNameEn                string        `json:"ServiceClassNameEn"`
	InternationalServiceClass         string        `json:"InternationalServiceClass"`
	CarDescription                    string        `json:"CarDescription"`
	ServiceClassTranscript            interface{}   `json:"ServiceClassTranscript"`
	FreePlaces                        string        `json:"FreePlaces"`
	FreePlacesWithCoordinates         interface{}   `json:"FreePlacesWithCoordinates"`
	FreePlacesByCompartments          interface{}   `json:"FreePlacesByCompartments"`
	PlaceQuantity                     int           `json:"PlaceQuantity"`
	IsTwoStorey                       bool          `json:"IsTwoStorey"`
	Services                          []string      `json:"Services"`
	PetTransportationShortDescription interface{}   `json:"PetTransportationShortDescription"`
	PetTransportationFullDescription  interface{}   `json:"PetTransportationFullDescription"`
	MinPrice                          float64       `json:"MinPrice"`
	MaxPrice                          float64       `json:"MaxPrice"`
	ServiceCost                       float64       `json:"ServiceCost"`
	PlaceReservationType              string        `json:"PlaceReservationType"`
	Carrier                           string        `json:"Carrier"`
	CarrierDisplayName                interface{}   `json:"CarrierDisplayName"`
	HasGenderCabins                   bool          `json:"HasGenderCabins"`
	RzhdCardTypes                     []interface{} `json:"RzhdCardTypes"`
	TrainNumber                       string        `json:"TrainNumber"`
	ArrivalDateTime                   string        `json:"ArrivalDateTime"`
	LocalArrivalDateTime              string        `json:"LocalArrivalDateTime"`
	HasNoInterchange                  bool          `json:"HasNoInterchange"`
	HasPlaceNumeration                bool          `json:"HasPlaceNumeration"`
	IsBeddingSelectionPossible        bool          `json:"IsBeddingSelectionPossible"`
	HasElectronicRegistration         bool          `json:"HasElectronicRegistration"`
	HasDynamicPricing                 bool          `json:"HasDynamicPricing"`
	HasPlacesNearBabies               bool          `json:"HasPlacesNearBabies"`
	HasPlacesNearPlayground           bool          `json:"HasPlacesNearPlayground"`
	HasPlacesNearPets                 bool          `json:"HasPlacesNearPets"`
	HasNonRefundableTariff            bool          `json:"HasNonRefundableTariff"`
	IsAdditionalPassengerAllowed      bool          `json:"IsAdditionalPassengerAllowed"`
	IsChildTariffTypeAllowed          bool          `json:"IsChildTariffTypeAllowed"`
	CarPlaceType                      string        `json:"CarPlaceType"`
	CarPlaceDirection                 interface{}   `json:"CarPlaceDirection"`
	Discounts                         []interface{} `json:"Discounts"`
	IsSaleForbidden                   bool          `json:"IsSaleForbidden"`
	AvailabilityIndication            string        `json:"AvailabilityIndication"`
	IsThreeHoursReservationAvailable  bool          `json:"IsThreeHoursReservationAvailable"`
	Road                              interface{}   `json:"Road"`
	InfoRequestSchema                 string        `json:"InfoRequestSchema"`
	PassengerSpecifyingRules          string        `json:"PassengerSpecifyingRules"`
	IsMealOptionPossible              bool          `json:"IsMealOptionPossible"`
	IsAdditionalMealOptionPossible    bool          `json:"IsAdditionalMealOptionPossible"`
	IsOnRequestMealOptionPossible     bool          `json:"IsOnRequestMealOptionPossible"`
	MealSalesOpenedTill               string        `json:"MealSalesOpenedTill"`
	IsTransitDocumentRequired         bool          `json:"IsTransitDocumentRequired"`
	IsInterstate                      bool          `json:"IsInterstate"`
	ClientFeeCalculation              interface{}   `json:"ClientFeeCalculation"`
	AgentFeeCalculation               interface{}   `json:"AgentFeeCalculation"`
	IsBranded                         bool          `json:"IsBranded"`
	IsBuffet                          bool          `json:"IsBuffet"`
	TripDirection                     string        `json:"TripDirection"`
	IsFromUkrainianCalcCenter         bool          `json:"IsFromUkrainianCalcCenter"`
	IsForDisabledPersons              bool          `json:"IsForDisabledPersons"`
	IsCarWithoutPlaces                bool          `json:"IsCarWithoutPlaces"`
	IsSpecialSaleMode                 bool          `json:"IsSpecialSaleMode"`
	BoardingSystemType                interface{}   `json:"BoardingSystemType"`
	AvailableBaggageTypes             interface{}   `json:"AvailableBaggageTypes"`
}

type TrainInfo struct {
	TrainNumber                      string      `json:"TrainNumber"`
	TrainNumberToGetRoute            string      `json:"TrainNumberToGetRoute"`
	DisplayTrainNumber               string      `json:"DisplayTrainNumber"`
	TrainDescription                 string      `json:"TrainDescription"`
	TrainFrequency                   interface{} `json:"TrainFrequency"`
	TrainName                        string      `json:"TrainName"`
	TransportType                    string      `json:"TransportType"`
	IsCarPricingSupported            bool        `json:"IsCarPricingSupported"`
	OriginName                       string      `json:"OriginName"`
	InitialStationName               interface{} `json:"InitialStationName"`
	OriginStationCode                string      `json:"OriginStationCode"`
	DestinationName                  string      `json:"DestinationName"`
	FinalStationName                 interface{} `json:"FinalStationName"`
	DestinationStationCode           string      `json:"DestinationStationCode"`
	DestinationNames                 []string    `json:"DestinationNames"`
	FinalStationNames                interface{} `json:"FinalStationNames"`
	DepartureDateTime                string      `json:"DepartureDateTime"`
	LocalDepartureDateTime           string      `json:"LocalDepartureDateTime"`
	ArrivalDateTime                  string      `json:"ArrivalDateTime"`
	LocalArrivalDateTime             string      `json:"LocalArrivalDateTime"`
	ArrivalDateTimes                 []string    `json:"ArrivalDateTimes"`
	LocalArrivalDateTimes            []string    `json:"LocalArrivalDateTimes"`
	DepartureDateFromFormingStation  string      `json:"DepartureDateFromFormingStation"`
	DepartureStopTime                int         `json:"DepartureStopTime"`
	ArrivalStopTime                  int         `json:"ArrivalStopTime"`
	TripDuration                     int         `json:"TripDuration"`
	TripDistance                     int         `json:"TripDistance"`
	IsSuburban                       bool        `json:"IsSuburban"`
	IsComponent                      bool        `json:"IsComponent"`
	CarServices                      interface{} `json:"CarServices"`
	IsSaleForbidden                  bool        `json:"IsSaleForbidden"`
	IsTicketPrintRequiredForBoarding bool        `json:"IsTicketPrintRequiredForBoarding"`
	BookingSystem                    string      `json:"BookingSystem"`
	Provider                         string      `json:"Provider"`
	IsVrStorageSystem                bool        `json:"IsVrStorageSystem"`
	BuybackDate                      interface{} `json:"BuybackDate"`
	PlacesStorageType                string      `json:"PlacesStorageType"`
	BoardingSystemTypes              interface{} `json:"BoardingSystemTypes"`
}

type SearchCarPricingResponse struct {
	OriginCode                    string               `json:"OriginCode"`
	DestinationCode               string               `json:"DestinationCode"`
	OriginTimeZoneDifference      int                  `json:"OriginTimeZoneDifference"`
	DestinationTimeZoneDifference int                  `json:"DestinationTimeZoneDifference"`
	Cars                          []Car                `json:"Cars"`
	RoutePolicy                   string               `json:"RoutePolicy"`
	TrainInfo                     TrainInfo            `json:"TrainInfo"`
	IsFromUkrain                  bool                 `json:"IsFromUkrain"`
	AllowedDocumentTypes          []string             `json:"AllowedDocumentTypes"`
	ClientFeeCalculation          ClientFeeCalculation `json:"ClientFeeCalculation"`
	AgentFeeCalculation           AgentFeeCalculation  `json:"AgentFeeCalculation"`
	BookingSystem                 string               `json:"BookingSystem"`
	CarTariffPrices               interface{}          `json:"CarTariffPrices"`
}

type ReservationBlankRequest struct {
	OrderID              int         `json:"OrderID"`
	OrderItemID          interface{} `json:"OrderItemID"`
	OrderItemIds         []int       `json:"OrderItemIds"`
	RetrieveMainServices bool        `json:"RetrieveMainServices"`
	RetrieveUpsales      bool        `json:"RetrieveUpsales"`
	BlankLanguage        string      `json:"BlankLanguage"`
}

type ReservationBlankResponse struct {
	RouteReceipt []byte
}

type ReservationBlankAsHTMLRequest struct {
	OrderItemID      int         `json:"OrderItemID"`
	OrderItemIds     []int       `json:"OrderItemIds"`
	OrderItemBlankID interface{} `json:"OrderItemBlankID"`
	BlankLanguage    string      `json:"BlankLanguage"`
}

type ReservationBlankAsHTMLResponse struct {
	RouteReceipt []byte
}
