package task

const (
	settlementAgryzID           = 20012
	settlementAnapaID           = 1107
	settlementArhangelskID      = 20
	settlementBakuID            = 10253
	settlementBalakovoID        = 11143
	settlementBaranovichyID     = 21015
	settlementBarnaulID         = 197
	settlementBelgorodID        = 4
	settlementBrestID           = 153
	settlementCheboksaryID      = 45
	settlementChelyabinskID     = 56
	settlementDneprID           = 141
	settlementGomelID           = 155
	settlementGrodnoID          = 10274
	settlementIzhevskID         = 44
	settlementKazanID           = 43
	settlementKharkovID         = 147
	settlementKhmelnickiyID     = 961
	settlementKievID            = 143
	settlementKirovID           = 46
	settlementKishinevID        = 10313
	settlementKislovodskID      = 11062
	settlementKovelID           = 23035
	settlementKrasnoufimskID    = 20691
	settlementKrasnoyarskID     = 62
	settlementKrivoyRogID       = 10347
	settlementLvovID            = 144
	settlementMakhachkalaID     = 28
	settlementMineralniyeVodiID = 11063
	settlementMinskID           = 157
	settlementMoscowID          = 213
	settlementMurmanskID        = 23
	settlementNikolaevID        = 148
	settlementNizhnevartovskID  = 1091
	settlementNizhnyNovgorodID  = 23243
	settlementNoviyUrengoyID    = 11230
	settlementNovokuznetskID    = 237
	settlementNovorossiyskID    = 970
	settlementNovosibirskID     = 65
	settlementOdessaID          = 145
	settlementOmskID            = 66
	settlementOrelID            = 10
	settlementOrenburgID        = 48
	settlementOrskID            = 11091
	settlementPechoraID         = 10942
	settlementPenzaID           = 49
	settlementPermID            = 50
	settlementPolockID          = 10275
	settlementRigaID            = 11474
	settlementRostovNaDonuID    = 39
	settlementSamaraID          = 51
	settlementSaranskID         = 42
	settlementSaratovID         = 194
	settlementSmolenskID        = 12
	settlementSochiID           = 239
	settlementSpbID             = 2
	settlementSyktyvkarID       = 19
	settlementTaganrogID        = 971
	settlementTallinID          = 11481
	settlementTyumenID          = 55
	settlementUfaID             = 172
	settlementUlyanovskID       = 195
	settlementUsinskID          = 10944
	settlementVladikavkazID     = 33
	settlementVologdaID         = 21
	settlementVorkutaID         = 10940
	settlementYekaterinburgID   = 54
	settlementZhmerinkaID       = 22884
)

type salesDepthKey struct {
	fromSettlementID int
	toSettlementID   int
	number           string
}

var salesDepthRules = map[salesDepthKey]int{}

type SalesDepthRule struct {
	fromSettlementID int
	toSettlementID   int
	numbers          []string
	depth            int
}

var rules = []SalesDepthRule{
	{settlementMoscowID, settlementSpbID, []string{"003", "004"}, 120},
	{settlementMoscowID, settlementKievID, []string{"005", "006"}, 45},
	{settlementKharkovID, settlementMoscowID, []string{"019", "020"}, 45},
	{settlementOdessaID, settlementMoscowID, []string{"023", "024"}, 45},
	{settlementKievID, settlementSpbID, []string{"053", "054", "143", "144"}, 45},
	{settlementKharkovID, settlementSpbID, []string{"053", "054", "143", "144"}, 45},
	{settlementMoscowID, settlementKhmelnickiyID, []string{"055", "056", "089", "090"}, 45},
	{settlementMoscowID, settlementZhmerinkaID, []string{"055", "056", "089", "090"}, 45},
	{settlementNikolaevID, settlementMoscowID, []string{"061", "062"}, 45},
	{settlementLvovID, settlementMoscowID, []string{"073", "074", "077", "078"}, 45},
	{settlementKovelID, settlementMoscowID, []string{"073", "074", "077", "078"}, 45},
	{settlementKrivoyRogID, settlementMoscowID, []string{"073", "074", "105", "106"}, 45},
	{settlementDneprID, settlementMoscowID, []string{"095", "096", "105", "106"}, 45},
	{settlementBakuID, settlementKharkovID, []string{"369", "370"}, 45},

	{settlementKishinevID, settlementMoscowID, []string{"047", "048", "065", "066", "341", "342"}, 45},
	{settlementKishinevID, settlementSpbID, []string{"061", "062"}, 45},

	{settlementMinskID, settlementMoscowID, []string{"001", "002", "025", "026"}, 60},
	{settlementMinskID, settlementMoscowID, []string{"001", "002", "025", "026"}, 60},
	{settlementBrestID, settlementMoscowID, []string{"027", "028"}, 60},
	{settlementBrestID, settlementSpbID, []string{"049", "050"}, 60},
	{settlementMinskID, settlementNovosibirskID, []string{"063", "064"}, 60},
	{settlementMinskID, settlementMurmanskID, []string{"065", "066"}, 60},
	{settlementBrestID, settlementSaratovID, []string{"067", "068"}, 60},
	{settlementGrodnoID, settlementMoscowID, []string{"077", "078"}, 60},
	{settlementBrestID, settlementMoscowID, []string{"003", "004", "007", "008", "095", "096"}, 60},
	{settlementBrestID, settlementNovosibirskID, []string{"103", "104"}, 60},
	{settlementBrestID, settlementMoscowID, []string{"131", "132"}, 60},
	{settlementMinskID, settlementArhangelskID, []string{"133", "134"}, 60},
	{settlementMoscowID, settlementTallinID, []string{"033", "034"}, 60},
	{settlementMoscowID, settlementPolockID, []string{"039", "040"}, 60},
	{settlementMinskID, settlementSpbID, []string{"051", "052"}, 60},
	{settlementMoscowID, settlementGomelID, []string{"055", "056"}, 60},
	{settlementRigaID, settlementMoscowID, []string{"001", "002"}, 60},
	{settlementRigaID, settlementSpbID, []string{"001", "002"}, 60},
	{settlementGomelID, settlementSpbID, []string{"083", "084"}, 60},
	{settlementBaranovichyID, settlementSaratovID, []string{"307", "308"}, 60},
	{settlementMinskID, settlementKazanID, []string{"327", "328"}, 60},
	{settlementMinskID, settlementSpbID, []string{"249", "250"}, 60},

	//# TRAINS-5705: Updates from 13.05.20
	{settlementKazanID, settlementMoscowID, []string{"001", "002"}, 90},
	{settlementSpbID, settlementMoscowID, []string{"001", "002", "005", "006", "751", "752", "755", "756", "773", "774", "777", "778"}, 90},
	{settlementKislovodskID, settlementMoscowID, []string{"003", "004"}, 120},
	{settlementSamaraID, settlementMoscowID, []string{"009", "010"}, 90},
	{settlementAnapaID, settlementMoscowID, []string{"011", "012"}, 120},
	{settlementSaratovID, settlementSochiID, []string{"013", "014"}, 90},
	{settlementMurmanskID, settlementMoscowID, []string{"015", "016", "241", "242"}, 90},
	{settlementMurmanskID, settlementBelgorodID, []string{"015", "016"}, 90},
	{settlementMurmanskID, settlementSmolenskID, []string{"015", "016"}, 90},
	{settlementRostovNaDonuID, settlementMoscowID, []string{"019", "020"}, 120},
	{settlementTaganrogID, settlementMoscowID, []string{"019", "020"}, 90},
	{settlementKazanID, settlementMoscowID, []string{"023", "024"}, 120},
	{settlementNovorossiyskID, settlementMoscowID, []string{"023", "024"}, 90},
	{settlementNovorossiyskID, settlementMoscowID, []string{"029", "030"}, 120},
	{settlementSpbID, settlementSochiID, []string{"035", "036"}, 120},
	{settlementSaranskID, settlementMoscowID, []string{"041", "042"}, 120},
	{settlementBalakovoID, settlementMoscowID, []string{"047", "048"}, 90},
	{settlementKislovodskID, settlementSpbID, []string{"049", "050"}, 90},
	{settlementCheboksaryID, settlementMoscowID, []string{"053", "054"}, 90},
	{settlementNovokuznetskID, settlementKislovodskID, []string{"059", "060"}, 90},
	{settlementOmskID, settlementKislovodskID, []string{"059", "060"}, 90},
	{settlementOmskID, settlementUfaID, []string{"059", "060"}, 90},
	{settlementArhangelskID, settlementSochiID, []string{"079", "080"}, 90},
	{settlementVologdaID, settlementSochiID, []string{"079", "080"}, 90},
	{settlementNizhnyNovgorodID, settlementSochiID, []string{"087", "088"}, 90},
	{settlementSmolenskID, settlementSpbID, []string{"087", "088"}, 90},
	{settlementNizhnyNovgorodID, settlementVorkutaID, []string{"089", "090"}, 90},
	{settlementNizhnyNovgorodID, settlementKirovID, []string{"089", "090"}, 90},
	{settlementNizhnyNovgorodID, settlementUsinskID, []string{"089", "090"}, 90},
	{settlementKirovID, settlementUsinskID, []string{"089", "090"}, 90},
	{settlementSochiID, settlementMoscowID, []string{"101", "102", "103", "104"}, 120},
	{settlementTaganrogID, settlementRostovNaDonuID, []string{"119", "120"}, 90},
	{settlementBelgorodID, settlementSpbID, []string{"119", "120"}, 90},
	{settlementOrelID, settlementSpbID, []string{"119", "120"}, 90},
	{settlementKrasnoyarskID, settlementSochiID, []string{"127", "128"}, 90},
	{settlementUfaID, settlementSochiID, []string{"127", "128"}, 90},
	{settlementSamaraID, settlementSochiID, []string{"127", "128"}, 90},
	{settlementKrasnoyarskID, settlementAnapaID, []string{"129"}, 90},
	{settlementOrskID, settlementMoscowID, []string{"131", "132"}, 90},
	{settlementOrenburgID, settlementMoscowID, []string{"131", "132"}, 90},
	{settlementMakhachkalaID, settlementSpbID, []string{"135", "136"}, 90},
	{settlementVladikavkazID, settlementSpbID, []string{"135", "136"}, 90},
	{settlementOrenburgID, settlementMoscowID, []string{"137", "138"}, 90},
	{settlementSamaraID, settlementMoscowID, []string{"137", "138"}, 90},
	{settlementBarnaulID, settlementSochiID, []string{"139", "140"}, 90},
	{settlementPenzaID, settlementSochiID, []string{"139", "140"}, 90},
	{settlementNovosibirskID, settlementSochiID, []string{"139", "140"}, 90},
	{settlementOmskID, settlementSochiID, []string{"139", "140"}, 90},
	{settlementSyktyvkarID, settlementUsinskID, []string{"305", "306"}, 90},
	{settlementPermID, settlementNovorossiyskID, []string{"325", "326"}, 90},
	{settlementUfaID, settlementNoviyUrengoyID, []string{"331", "332"}, 90},
	{settlementSamaraID, settlementNoviyUrengoyID, []string{"331", "332"}, 90},
	{settlementYekaterinburgID, settlementNovorossiyskID, []string{"335", "336"}, 90},
	{settlementNizhnyNovgorodID, settlementNovorossiyskID, []string{"339", "340"}, 90},
	{settlementChelyabinskID, settlementSochiID, []string{"343", "344"}, 90},
	{settlementOrskID, settlementSochiID, []string{"343", "344"}, 90},
	{settlementOrenburgID, settlementSochiID, []string{"343", "344"}, 90},
	{settlementNizhnevartovskID, settlementSochiID, []string{"345", "346"}, 90},
	{settlementPermID, settlementSochiID, []string{"353", "354"}, 90},
	{settlementUlyanovskID, settlementSochiID, []string{"353", "354"}, 90},
	{settlementNoviyUrengoyID, settlementKazanID, []string{"377", "378"}, 90},
	{settlementNoviyUrengoyID, settlementIzhevskID, []string{"377", "378"}, 90},
	{settlementNoviyUrengoyID, settlementTyumenID, []string{"377", "378"}, 90},
	{settlementVorkutaID, settlementSochiID, []string{"309", "310"}, 90},
	{settlementVorkutaID, settlementNovorossiyskID, []string{"309", "310"}, 90},
	{settlementUsinskID, settlementSochiID, []string{"309", "310"}, 90},
	{settlementRostovNaDonuID, settlementNovorossiyskID, []string{"311", "312"}, 90},
	{settlementKirovID, settlementKislovodskID, []string{"367", "368"}, 90},
	{settlementVladikavkazID, settlementMineralniyeVodiID, []string{"621", "622"}, 90},
	{settlementPechoraID, settlementUsinskID, []string{"691", "692"}, 90},
	{settlementIzhevskID, settlementKrasnoufimskID, []string{"137", "697", "698"}, 90},
	{settlementIzhevskID, settlementAgryzID, []string{"137", "697", "698"}, 90},
	{settlementIzhevskID, settlementNoviyUrengoyID, []string{"137", "697", "698"}, 90},
}

const suburbanSalesDepth = 10
const trainPurchaseSoldOutDefaultSalesDepth = 45

func buildSalesDepth() {
	if len(salesDepthRules) != 0 {
		return
	}
	for _, rule := range rules {
		for _, number := range rule.numbers {
			salesDepthRules[salesDepthKey{rule.fromSettlementID, rule.toSettlementID, number}] = rule.depth
			salesDepthRules[salesDepthKey{rule.toSettlementID, rule.fromSettlementID, number}] = rule.depth
		}
	}
}

func getSalesDepth(segment *TrainSegment) (int, bool) {
	digitalNumber := digitsOnly(segment.number)
	if segment.isSuburban || isSuburbanNumber(digitalNumber) {
		return suburbanSalesDepth, true
	}

	if segment.startStation == nil || segment.endStation == nil {
		return 0, false
	}

	startSettlementID := segment.startStation.SettlementId
	endSettlementID := segment.endStation.SettlementId

	buildSalesDepth()
	depth, ok := salesDepthRules[salesDepthKey{int(startSettlementID), int(endSettlementID), digitalNumber}]
	if ok {
		return depth, true
	}
	return trainPurchaseSoldOutDefaultSalesDepth, true
}
