package task

import (
	"strconv"

	"a.yandex-team.ru/travel/proto/dicts/rasp"
	tariffsModels "a.yandex-team.ru/travel/trains/library/go/tariffs/models"
)

func makeTrainPlace(class coachType, value trainTariff) *tariffsModels.TrainPlace {
	trainPlace := &tariffsModels.TrainPlace{}
	trainPlace.Count = uint32(value.seats)
	trainPlace.CoachType = string(class)
	trainPlace.ServiceClass = *value.serviceClass
	trainPlace.LowerCount = uint32(value.lowerSeats)
	trainPlace.UpperCount = uint32(value.upperSeats)
	trainPlace.LowerSideCount = uint32(value.lowerSideSeats)
	trainPlace.UpperSideCount = uint32(value.upperSideSeats)
	trainPlace.MaxSeatsInTheSameCar = uint32(value.maxSeatsInTheSameCar)
	trainPlace.Price = &tariffsModels.TrainPlacePrice{}
	trainPlace.Price.Value = "0"
	trainPlace.HasNonRefundableTariff = value.hasNonRefundableTariff

	trainPlace.PriceDetails = &tariffsModels.TrainPlacePriceDetails{}
	trainPlace.PriceDetails.ServicePrice = strconv.FormatFloat(value.servicePrice.value, 'f', 2, 64)
	trainPlace.PriceDetails.TicketPrice = strconv.FormatFloat(value.ticketPrice.value, 'f', 2, 64)
	trainPlace.PriceDetails.Fee = "0"
	trainPlace.PriceDetails.SeveralPrices = value.severalPrices

	return trainPlace
}

func BuildSegmentsWithTariff(segments []*TrainSegment, pointFromCode int, pointToCode int) []*tariffsModels.DirectionTariffTrain {
	var segmentsWithTariff []*tariffsModels.DirectionTariffTrain
	for _, segment := range segments {
		if segment.arrival == nil || segment.departure == nil {
			continue
		}
		segmentWithTariff := &tariffsModels.DirectionTariffTrain{}
		segmentWithTariff.Arrival = *segment.arrival
		arrivalID, _ := strconv.Atoi(segment.apiSegment.StationTo.Id)
		segmentWithTariff.ArrivalStationID = int32(arrivalID)
		segmentWithTariff.Departure = *segment.departure
		departureID, _ := strconv.Atoi(segment.apiSegment.StationFrom.Id)
		segmentWithTariff.DepartureStationID = int32(departureID)
		segmentWithTariff.Number = segment.number
		segmentWithTariff.DisplayNumber = segment.number
		segmentWithTariff.HasDynamicPricing = segment.hasDynamicPricing
		segmentWithTariff.TwoStorey = segment.twoStorey
		segmentWithTariff.IsSuburban = segment.isSuburban
		segmentWithTariff.CoachOwners = segment.coachOwners
		segmentWithTariff.ElectronicTicket = segment.tariffs["electronic_ticket"]

		if segment.firstCountryCode != nil {
			segmentWithTariff.FirstCountryCode = *segment.firstCountryCode
		}
		if segment.lastCountryCode != nil {
			segmentWithTariff.LastCountryCode = *segment.lastCountryCode
		}

		segmentWithTariff.Places = []*tariffsModels.TrainPlace{}

		for class, value := range segment.tariffsClasses {
			segmentWithTariff.Places = append(segmentWithTariff.Places, makeTrainPlace(class, value))
		}
		if segment.apiSegment.Tariffs != nil && segment.apiSegment.Tariffs.OptionalBrokenClassesCode != nil {
			segmentWithTariff.BrokenClasses = new(tariffsModels.TariffBrokenClasses)
			segmentWithTariff.BrokenClasses.Unknown = []uint32{1}
		}
		for key, value := range segment.brokenClasses {
			if segmentWithTariff.BrokenClasses == nil {
				segmentWithTariff.BrokenClasses = new(tariffsModels.TariffBrokenClasses)
			}
			var tariffErrors []uint32
			for _, tariffError := range value {
				tariffErrors = append(tariffErrors, uint32(tariffError))
			}
			switch key {
			case unknownCoachType:
				segmentWithTariff.BrokenClasses.Unknown = tariffErrors
			case softCoachType:
				segmentWithTariff.BrokenClasses.Soft = tariffErrors
			case platzkarteCoachType:
				segmentWithTariff.BrokenClasses.Platzkarte = tariffErrors
			case compartmentCoachType:
				segmentWithTariff.BrokenClasses.Compartment = tariffErrors
			case suiteCoachType:
				segmentWithTariff.BrokenClasses.Suite = tariffErrors
			case commonCoachType:
				segmentWithTariff.BrokenClasses.Common = tariffErrors
			case sittingCoachType:
				segmentWithTariff.BrokenClasses.Sitting = tariffErrors
			}
		}

		if segment.titleCommon != nil {
			segmentWithTariff.TitleDict = new(tariffsModels.ThreadTitle)
			segmentWithTariff.TitleDict.IsRing = segment.titleCommon.IsRing
			segmentWithTariff.TitleDict.IsCombined = segment.titleCommon.IsCombined
			segmentWithTariff.TitleDict.TransportType = rasp.TTransport_EType_name[int32(segment.titleCommon.TransportType)]
			segmentWithTariff.TitleDict.Type = rasp.TThreadTitle_EType_name[int32(segment.titleCommon.Type)]
			for i := 0; i < len(segment.titleCommon.TitleParts); i++ {
				titlePart := strconv.Itoa(int(segment.titleCommon.TitleParts[i].SettlementId))
				segmentWithTariff.TitleDict.TitleParts = append(segmentWithTariff.TitleDict.TitleParts, "c"+titlePart)
			}
		} else {
			segmentWithTariff.TitleDict = nil
		}

		segmentWithTariff.Provider = segment.provider
		segmentWithTariff.RawTrainName = segment.rawTrainName
		if segment.thread != nil {
			segmentWithTariff.HasThread = true
		}
		segmentsWithTariff = append(segmentsWithTariff, segmentWithTariff)
	}
	return segmentsWithTariff
}
