package task

import (
	"context"
	"fmt"

	"a.yandex-team.ru/library/go/core/log/zap"
	"a.yandex-team.ru/library/go/core/metrics"
	"a.yandex-team.ru/travel/buses/library/go/worker"
	"a.yandex-team.ru/travel/library/go/logbroker"
	travelMetrics "a.yandex-team.ru/travel/library/go/metrics"
	"a.yandex-team.ru/travel/library/go/vault"
	"a.yandex-team.ru/travel/trains/worker/internal/pkg/dict"
	ilogbroker "a.yandex-team.ru/travel/trains/worker/internal/pkg/logbroker"
)

type SearchWorker struct {
	worker         *worker.Worker
	searchProducer *logbroker.Producer
}

func NewSearchWorker(
	ctx context.Context,
	queue *SearchTaskQueue,
	logger *zap.Logger,
	metricsRegistry metrics.Registry,
	trainTariffsTaskConfig *TrainTariffsTaskConfig,
	producerConfig ilogbroker.ProducerConfig,
	raspRepo *dict.DictRepo,
) (*SearchWorker, error) {
	const funcName = "NewSearchWorker"

	searchMetrics := travelMetrics.NewAppMetrics(
		metricsRegistry.WithPrefix("search"),
	)

	secretResolver := vault.NewYavSecretsResolver()
	searchProducer, err := ilogbroker.NewProducer(producerConfig, secretResolver, logger)

	if err != nil {
		return nil, fmt.Errorf("can not create search producer: %w", err)
	}

	trainTariffsTask, err := NewTrainTariffsTask(
		ctx,
		queue,
		logger,
		trainTariffsTaskConfig,
		searchProducer,
		searchMetrics,
		raspRepo,
	)
	if err != nil {
		return nil, fmt.Errorf("%s: %w", funcName, err)
	}
	worker := worker.NewWorker(trainTariffsTask)

	return &SearchWorker{
		worker:         worker,
		searchProducer: searchProducer,
	}, nil
}

func (sw *SearchWorker) Run(ctx context.Context) error {
	const funcName = "SearchWorker.Run"
	if err := sw.searchProducer.Run(ctx); err != nil {
		return fmt.Errorf("%s: failed to run searchProducer: %w", funcName, err)
	}
	sw.worker.Run(ctx)
	return nil
}
