package ru.yandex.atom.application

import scala.collection.mutable.ListBuffer

/**
 *
 * Этот уровень нужен, чтобы не страдать.
 * Если заинлайнить весь этот код сразу в TypesafeApplication, то val init не будет проинициализирован в момент вызова
 * delayedInit 0_o. А на трейты магия DelayedInit не распространяется.
 * А TypesafeApplication хотелось бы быть классом, а не трейтом.
 *
 * @author avhaliullin
 */
trait AbstractApp extends DelayedInit {
  protected[this] val init = new ListBuffer[() => Unit]()

  protected[this] val _postInit = new ListBuffer[() => Unit]()

  override def delayedInit(body: => Unit): Unit = synchronized {
    init += (() => body)
  }

  def inPostInit(block: => Unit): Unit = synchronized {
    _postInit += (() => block)
  }
}
