package ru.yandex.atom.db.cassandra

import scala.collection.JavaConversions._
import java.{util => ju}

/**
 * @author avhaliullin
 */
sealed trait CQLValue {
  //  ASCII     (1,  String.class),
  //  BIGINT    (2,  Long.class),
  //  BLOB      (3,  ByteBuffer.class),
  //  BOOLEAN   (4,  Boolean.class),
  //  COUNTER   (5,  Long.class),
  //  DECIMAL   (6,  BigDecimal.class),
  //  DOUBLE    (7,  Double.class),
  //  FLOAT     (8,  Float.class),
  //  INET      (16, InetAddress.class),
  //  INT       (9,  Integer.class),
  //  TEXT      (10, String.class),
  //  TIMESTAMP (11, Date.class),
  //  UUID      (12, UUID.class),
  //  VARCHAR   (13, String.class),
  //  VARINT    (14, BigInteger.class),
  //  TIMEUUID  (15, UUID.class),
  //  LIST      (32, List.class),
  //  SET       (34, Set.class),
  //  MAP       (33, Map.class),
  //  CUSTOM    (0,  ByteBuffer.class);
  def value: AnyRef
}

object CQLValue {

  import java.{util => ju}
  import java.{lang => jl}

  private case class DefaultCQLValue(value: AnyRef) extends CQLValue

  implicit def forString(s: String): CQLValue = new DefaultCQLValue(s)

  implicit def forLong(x: Long): CQLValue = new DefaultCQLValue(x: jl.Long)

  implicit def forInt(x: Int): CQLValue = new DefaultCQLValue(x: jl.Integer)

  implicit def forList[T <% CQLValue](x: Seq[T]): CQLValue = new DefaultCQLValue(x.map(x => implicitly[T => CQLValue].apply(x).value): ju.List[AnyRef])

  implicit def forSet[T <% CQLValue](x: Set[T]): CQLValue = new DefaultCQLValue(x.map(x => implicitly[T => CQLValue].apply(x).value): ju.Set[AnyRef])
}