package ru.yandex.atom.db.cassandra

import akka.actor.ActorRef
import ru.yandex.atom.utils.actor.messages._
import ru.yandex.atom.data.ReqID
import ru.yandex.atom.db.cassandra.querybuilder.{WriteStatement, SelectStatement}
import com.datastax.driver.core.Row
import ru.yandex.atom.data.ReqID

/**
 * @author avhaliullin
 */
trait CassandraActorComponent {
  def cassandraActor: ActorRef

  sealed trait CassandraRequest extends AbstractMessage

  object CassandraRequest {

    case class ReadRequest(id: ReqID, statement: SelectStatement) extends CassandraRequest

    case class WriteRequest(id: ReqID, statement: WriteStatement) extends CassandraRequest

  }

  sealed trait CassandraResponse extends ResponseMessage[CassandraRequest]

  object CassandraResponse {

    case class ReadResponse(request: CassandraRequest.ReadRequest, rows: Seq[Row]) extends CassandraResponse with SetReqType[CassandraRequest.ReadRequest]

    case class WriteResponse(request: CassandraRequest.WriteRequest) extends CassandraResponse with SetReqType[CassandraRequest.WriteRequest]

    case class FailureResponse(request: CassandraRequest, problem: Throwable) extends CassandraResponse with SetReqType[CassandraRequest] with IExceptionResponse

  }

}
