package ru.yandex.atom.db.cassandra

import com.datastax.driver.core.Row
import scala.concurrent.{ExecutionContext, Future}
import ru.yandex.atom.utils.concurrent.AsyncStream
import ru.yandex.atom.db.cassandra.querybuilder.{Statement, WriteStatement}

/**
 * @author avhaliullin
 */
trait CassandraComponent {
  def cassandra: Cassandra

  trait Cassandra {
    protected[this] implicit def executionContext: ExecutionContext

    def select(statement: Statement): Future[AsyncStream[Seq[Row]]]

    def execute(statement: Statement): Future[Seq[Row]] = {
      select(statement).flatMap(_.foldLeft(Seq[Row]())(_ ++ _))
    }

    def update(writeStatement: WriteStatement): Future[Unit] = {
      execute(writeStatement).map(x => ())
    }
  }

}
