package ru.yandex.atom.db.cassandra

import com.datastax.driver.core.policies.RetryPolicy
import com.datastax.driver.core.{WriteType, ConsistencyLevel, Statement}
import org.slf4j.LoggerFactory
import com.datastax.driver.core.policies.RetryPolicy.RetryDecision

/**
 * @author avhaliullin
 */
class CustomizableRetryPolicy(readTORetries: Int, writeTORetries: Int, unavailableRetries: Int) extends RetryPolicy {
  val log = LoggerFactory.getLogger(classOf[CustomizableRetryPolicy])

  def onReadTimeout(statement: Statement, cl: ConsistencyLevel, requiredResponses: Int, receivedResponses: Int, dataRetrieved: Boolean, nbRetry: Int) = {
    val leftRetries = readTORetries - nbRetry
    log.warn(s"Cassandra read timed out. Taken $nbRetry attempts, left $leftRetries ")
    if (leftRetries > 0) RetryDecision.retry(cl) else RetryDecision.rethrow()
  }

  def onWriteTimeout(statement: Statement, cl: ConsistencyLevel, writeType: WriteType, requiredAcks: Int, receivedAcks: Int, nbRetry: Int) = {
    val leftRetries = readTORetries - nbRetry
    log.warn(s"Cassandra write timed out. Taken $nbRetry attempts, left $leftRetries ")
    if (leftRetries > 0) RetryDecision.retry(cl) else RetryDecision.rethrow()
  }

  def onUnavailable(statement: Statement, cl: ConsistencyLevel, requiredReplica: Int, aliveReplica: Int, nbRetry: Int) = {
    val leftRetries = readTORetries - nbRetry
    log.warn(s"Cassandra node unavailable. Taken $nbRetry attempts, left $leftRetries ")
    if (leftRetries > 0) RetryDecision.retry(cl) else RetryDecision.rethrow()
  }

}
