package ru.yandex.atom.error

import com.datastax.driver.core.exceptions.{QueryExecutionException, DriverException}
import java.util.concurrent.TimeoutException


/**
 * @author avhaliullin
 */
sealed abstract class InternalProblem

object InternalProblem {

  case object TemporarilyProblem extends InternalProblem

  case object UnknownProblem extends InternalProblem

  def throwable2InternalProblem(t: Throwable): InternalProblem = ErrorUtils.unwrap(t) match {
    case ce: DriverException => ce match {
      case qe: QueryExecutionException => TemporarilyProblem
      case _ => UnknownProblem
    }
    case x: TimeoutException => TemporarilyProblem
    case _ => UnknownProblem
  }
}
