package ru.yandex.atom.error


/**
 * @author avhaliullin
 */
sealed abstract class UserProblem

object UserProblem {

  case class UrlListNotFound(userId: Long, id: Long) extends UserProblem

  case class InvalidUrlListSize(size: Int) extends UserProblem

  case class MalformedUrls(urls: Iterable[String]) extends UserProblem

  case class MalformedRequest(desc: String) extends UserProblem

}
