package ru.yandex.atom.service

import ru.yandex.atom.utils.actor.messages._
import ru.yandex.atom.data.GeminiRequestType
import ru.yandex.atom.error.{InternalProblem, UserProblem}
import ru.yandex.atom.data.ReqID
import akka.actor.ActorRef

/**
 * @author avhaliullin
 */
trait GeminiActorComponent {

  def geminiActor: ActorRef

  sealed trait GeminiRequest extends AbstractMessage

  object GeminiRequest {

    case class Ask(id: ReqID, tpe: GeminiRequestType, urls: Set[String]) extends GeminiRequest

  }

  sealed trait GeminiResponse extends ResponseMessage[GeminiRequest]

  object GeminiResponse {

    case class Answer(request: GeminiRequest.Ask, canonizedUrls: Map[String, String]) extends GeminiResponse with SetReqType[GeminiRequest.Ask]

    sealed trait FailureResponse extends GeminiResponse with SetReqType[GeminiRequest] {
      self: IFailureResponse =>
    }

    object FailureResponse {
      def apply(req: GeminiRequest, cause: IFailureMagnet): FailureResponse = {
        cause match {
          case IFailureMagnet.InternalProblemFailure(problem) => InternalProblemResponse(req, problem)
          case IFailureMagnet.UserProblemFailure(problem) => UserProblemResponse(req, problem)
        }
      }
    }

    case class UserProblemResponse(request: GeminiRequest, problem: UserProblem) extends FailureResponse with IUserProblemResponse

    case class InternalProblemResponse(request: GeminiRequest, problem: InternalProblem) extends FailureResponse with IInternalProblemResponse

  }

}
