package ru.yandex.atom.service

import akka.actor.{Actor, ActorLogging, ActorRef, Props}

/**
 * @author avhaliullin
 */
trait HardcodedKeysActorComponentImpl extends APIKeysActorComponent {

  class HardcodedKeysActor(delegate: ActorRef) extends Actor with ActorLogging {

    import APIKeysRequest._
    import APIKeysResponse._

    //    119263261       abaitsur        52b1b4a850af41b0a7e417491223a26f
    //    159435172       seo-wikimart    4f57d1604bc8a75f8ddb5fac13815ac9
    //    26690432        navosha         59e9b996083786aaa2546d05a5d02df0
    //    165457870       zagodya         8769bf94e562d2fea3010901a4c60919
    //    133743693       stat-kokoc      4e5dbe4e89e6b7630128a82d8640f036
    //    220080824       ya-sports-ru    df5d32bce9b6d5d0222c1000a169ef43
    //    11405526        tagantransport  a8be92a44354a7bd6e499d010cabcc85
    //    108246793       sportsdirect    f2f550cd3ff2a00b2bed34aac6ee0337
    //    41691574        dzgud           7260e54d40dcb75ef2083c8c12025c57
    //    1268227         rog-denis       69e30dd12b211e52d04eefb910a6fe29
    //    6791844         manokk          e4f8e2e5b1c6cbddad1bffb6d6f8e368
    //    35395262        thinkingwhat    ac34c32b57b7a20511f29a9b07b5a44c
    //    120160451       andreyhaliullin dfeb75c4560b8d7070a61f95f08b8519
    //    4975146         m-senin         ba76d0e198d7b7a6bac710531d6c2c28
    //    24713515        azakharov       4b780a3891bc9581894bf48049db90ad

    val key2Uid = Map[String, Long](
      "52b1b4a850af41b0a7e417491223a26f" -> 119263261,
      "4f57d1604bc8a75f8ddb5fac13815ac9" -> 159435172,
      "59e9b996083786aaa2546d05a5d02df0" -> 26690432,
      "8769bf94e562d2fea3010901a4c60919" -> 165457870,
      "4e5dbe4e89e6b7630128a82d8640f036" -> 133743693,
      "df5d32bce9b6d5d0222c1000a169ef43" -> 220080824,
      "a8be92a44354a7bd6e499d010cabcc85" -> 11405526,
      "f2f550cd3ff2a00b2bed34aac6ee0337" -> 108246793,
      "7260e54d40dcb75ef2083c8c12025c57" -> 41691574,
      "69e30dd12b211e52d04eefb910a6fe29" -> 1268227,
      "e4f8e2e5b1c6cbddad1bffb6d6f8e368" -> 6791844,
      "ac34c32b57b7a20511f29a9b07b5a44c" -> 35395262,
      "dfeb75c4560b8d7070a61f95f08b8519" -> 120160451,
      "ba76d0e198d7b7a6bac710531d6c2c28" -> 4975146,
      "4b780a3891bc9581894bf48049db90ad" -> 24713515
    )

    override def receive = {
      case req@CheckKey(id, key, ip) =>
        key2Uid.get(key) match {
          case None => delegate.tell(req, sender())
          case Some(uid) => sender() ! KeyChecked(req, key2Uid.get(key))
        }
      case other: APIKeysRequest =>
        delegate.tell(other, sender())
    }
  }

  object HardcodedKeysActor {
    def props(delegate: ActorRef) = Props(new HardcodedKeysActor(delegate))
  }

}
