package ru.yandex.atom.service

import akka.actor.ActorRef
import ru.yandex.atom.utils.actor.messages._
import ru.yandex.atom.error.InternalProblem
import ru.yandex.atom.data.ReqID

/**
 * @author avhaliullin
 */
trait IdGeneratorActorComponent {
  def idGeneratorActor: ActorRef

  sealed trait IdGeneratorRequest extends AbstractMessage

  object IdGeneratorRequest {

    case class NextId(id: ReqID) extends IdGeneratorRequest

  }

  sealed trait IdGeneratorResponse extends ResponseMessage[IdGeneratorRequest]

  object IdGeneratorResponse {

    case class NextIdResponse private[NextIdResponse](request: IdGeneratorRequest.NextId, generatedId: Long) extends IdGeneratorResponse
    with SetReqType[IdGeneratorRequest.NextId]

    object NextIdResponse {
      //Отводим младшие четыре бита под версию генератора id - генератор можно будет безболезненно менять
      def apply(request: IdGeneratorRequest.NextId, idVersion: Byte, id: Long): NextIdResponse = new NextIdResponse(
        request, (id << 4) + idVersion)
    }

    case class FailureResponse(request: IdGeneratorRequest, problem: InternalProblem) extends IdGeneratorResponse with SetReqType[IdGeneratorRequest] with IInternalProblemResponse

  }

}
