package ru.yandex.atom.service

import ru.yandex.atom.data.{ReqID, NormalizedUrl}
import akka.actor.ActorRef
import ru.yandex.atom.utils.actor.messages._
import ru.yandex.atom.error.{InternalProblem, UserProblem}

/**
 * @author avhaliullin
 */
trait UrlNormalizerActorComponent {
  def urlNormalizerActor: ActorRef

  sealed trait UrlNormalizerRequest extends AbstractMessage {
    def id: ReqID
  }

  object UrlNormalizerRequest {

    case class Normalize(id: ReqID, urls: Set[String]) extends UrlNormalizerRequest

  }

  sealed trait UrlNormalizerResponse extends ResponseMessage[UrlNormalizerRequest]

  object UrlNormalizerResponse {

    case class NormalizeResponse(request: UrlNormalizerRequest.Normalize, urls: Set[NormalizedUrl]
                                  ) extends UrlNormalizerResponse with SetReqType[UrlNormalizerRequest.Normalize]

    sealed trait FailureResponse extends UrlNormalizerResponse with SetReqType[UrlNormalizerRequest] {
      self: IFailureResponse =>
    }

    object FailureResponse {
      def apply(req: UrlNormalizerRequest, cause: IFailureMagnet): FailureResponse = cause match {
        case IFailureMagnet.InternalProblemFailure(problem) => InternalProblemResponse(req, problem)
        case IFailureMagnet.UserProblemFailure(problem) => UserProblemResponse(req, problem)
      }
    }

    case class UserProblemResponse(request: UrlNormalizerRequest, problem: UserProblem) extends FailureResponse with IUserProblemResponse

    case class InternalProblemResponse(request: UrlNormalizerRequest, problem: InternalProblem) extends FailureResponse with IInternalProblemResponse

  }

}
