package ru.yandex.atom.utils

import scala.concurrent.duration.FiniteDuration

/**
 * @author avhaliullin
 */
object TimeUtil {
  /**
   *
   * @param to
   * @param period
   * @param from
   * @return Сколько целых периодов period прошло с момента from до момента to
   */
  def periodsFrom(period: FiniteDuration, from: Long, to: Long): Long = {
    if (to < from) -1
    else {
      (to - from) / period.toMillis
    }
  }

  def applyPeriods(period: FiniteDuration, periodsCount: Long, from: Long): Long = {
    from + (period.toMillis * periodsCount)
  }
}
