package ru.yandex.atom.utils.actor

import akka.actor.{DiagnosticActorLogging, Actor}
import ru.yandex.atom.utils.actor.messages.AbstractMessage
import ru.yandex.atom.utils.log.AtomLogger

/**
 * @author avhaliullin
 */
trait AtomActorLogging extends DiagnosticActorLogging {
  this: Actor =>

  override def mdc(currentMessage: Any) = {
    currentMessage match {
      case x: AbstractMessage => Map("reqId" -> x.id)
      case _ => Map()
    }
  }

  val logWithId = AtomLogger(log)
}
