package ru.yandex.atom.zookeeper

/**
 * Zookeeper'овский Stat мутабельный
 *
 * @author avhaliullin
 */
case class Stat(czxid: Long, mzxid: Long, ctime: Long, mtime: Long, version: Int, cVersion: Int, aVersion: Int,
                ephemeralOwner: Long, dataLength: Int, numChildren: Int, pzxid: Long)

object Stat {
  def apply(stat: org.apache.zookeeper.data.Stat): Stat = {
    new Stat(stat.getCzxid, stat.getMzxid, stat.getCtime, stat.getMtime,
      stat.getVersion, stat.getCversion, stat.getAversion, stat.getEphemeralOwner, stat.getDataLength,
      stat.getNumChildren, stat.getPzxid)
  }
}