package ru.yandex.atom.zookeeper

import akka.actor.ActorRef
import ru.yandex.atom.utils.actor.messages._
import org.apache.zookeeper.{CreateMode, KeeperException}
import ru.yandex.atom.data.ReqID

/**
 * @author avhaliullin
 */
trait ZookeeperActorComponent {
  def zookeeperActor: ActorRef

  trait ZookeeperRequest extends AbstractMessage

  object ZookeeperRequest {

    case class UpdateRequest(id: ReqID, path: String, data: Array[Byte], version: Int) extends ZookeeperRequest

    case class CreateRequest(id: ReqID, path: String, data: Array[Byte], mode: CreateMode) extends ZookeeperRequest

    case class ExistsRequest(id: ReqID, path: String) extends ZookeeperRequest

    case class ReadRequest(id: ReqID, path: String) extends ZookeeperRequest

    case class DeleteRequest(id: ReqID, path: String, version: Int) extends ZookeeperRequest

    case class ChildrenRequest(id: ReqID, path: String) extends ZookeeperRequest

  }

  trait ZookeeperResponse extends ResponseMessage[ZookeeperRequest]

  object ZookeeperResponse {

    case class UpdateResponse(request: ZookeeperRequest.UpdateRequest, stat: Stat) extends ZookeeperResponse with SetReqType[ZookeeperRequest.UpdateRequest]

    case class CreateResponse(request: ZookeeperRequest.CreateRequest, createdPath: String) extends ZookeeperResponse with SetReqType[ZookeeperRequest.CreateRequest]

    case class ExistsResponse(request: ZookeeperRequest.ExistsRequest, stat: Stat) extends ZookeeperResponse with SetReqType[ZookeeperRequest.ExistsRequest]

    case class ReadResponse(request: ZookeeperRequest.ReadRequest, data: Array[Byte], stat: Stat) extends ZookeeperResponse with SetReqType[ZookeeperRequest.ReadRequest]

    case class DeleteResponse(request: ZookeeperRequest.DeleteRequest) extends ZookeeperResponse with SetReqType[ZookeeperRequest.DeleteRequest]

    case class ChildrenResponse(request: ZookeeperRequest.ChildrenRequest, children: Seq[String], stat: Stat) extends ZookeeperResponse with SetReqType[ZookeeperRequest.ChildrenRequest]

    case class FailureResponse[T <: ZookeeperRequest](request: T, problem: KeeperException) extends ZookeeperResponse with IExceptionResponse with SetReqType[T]

  }

}
