#!/bin/bash
TRIE_PATTERN=/var/lib/yandex/atom-api/periodic/trie-for-upload.*
yandex_environment () {
    if [ -f /etc/yandex/environment.type ]
    then
        cat /etc/yandex/environment.type
    else
        echo development
    fi
}

if [[ $(yandex_environment) == "production" ]]
then
    DEST=quinta-sas1.search.yandex.net::querydata/
fi

files=`ls -dt ${TRIE_PATTERN} 2>/dev/null | head -1`
for file in $files
do
  if [ -d $file ]
  then
    if [ -n "$DEST" ]
    then
        rsync -r ${file}/00[0-7] ${DEST} && rsync ${file}/atom-urls.trie.tag ${DEST}
    fi
  else
    echo "Matched file ${file} - but it's not a directory"
  fi
done

rm -rf ${TRIE_PATTERN}
