package ru.yandex.atom.periodic

import ru.yandex.atom.db.cassandra.{CassandraComponentImpl, CassandraActorComponentImpl}
import ru.yandex.atom.service._
import org.slf4j.LoggerFactory
import ru.yandex.atom.zookeeper.ZookeeperActorComponentImpl
import ru.yandex.atom.application.SprayApplication
import akka.actor.ActorSystem
import scala.concurrent.duration._
import scala.concurrent.ExecutionContext.Implicits.global
import ru.yandex.atom.periodic.clean.CleanerComponent

/**
 * @author avhaliullin
 */
object Main extends SprayApplication
with CassandraComponentImpl
with CassandraActorComponentImpl
with GeminiActorBinaryComponentImpl
with ZookeeperActorComponentImpl
with TrieBuilderComponent
with MainMirrorUpdaterComponent
with PeriodicRouterComponent
with CleanerComponent {

  def configResource = "periodic"

  val log = LoggerFactory.getLogger(getClass)

  val actorSystem = ActorSystem("atom-periodic", config)

  val cassandra = new CassandraImpl(config("cassandra"))

  val geminiActor = actorSystem.actorOf(GeminiActor.props(config("gemini")), "gemini")

  val cassandraActor = actorSystem.actorOf(CassandraActor.props, "cassandra")

  val zookeeperActor = actorSystem.actorOf(ZookeeperActorImpl.props(config("zookeeper")), "zookeeper")

  val cleanerActor = actorSystem.actorOf(Cleaner.props, "cleaner")

  val trieBuilder = new TrieBuilder(config("trieBuilder"))

  val mainMirrorUpdater = new MainMirrorUpdater(config("mainMirrorUpdater"))

  val httpRouter = actorSystem.actorOf(PeriodicRouter.props, "http-handler")

  actorSystem.scheduler.schedule(10 seconds, 10 seconds)(trieBuilder.obtainLockAndBuild())
  actorSystem.scheduler.schedule(15 seconds, 10 seconds)(mainMirrorUpdater.obtainLockAndUpdateMirrors())
}
