package ru.yandex.atom.periodic.clean

import ru.yandex.atom.application.AbstractApp
import akka.actor.{Props, ActorRef, Actor}
import ru.yandex.atom.utils.actor.AtomActorLogging
import ru.yandex.atom.data.ReqID
import concurrent.duration._
import scala.concurrent.ExecutionContext.Implicits.global

/**
 * @author avhaliullin
 */
trait CleanerComponent {
  component: AbstractApp =>

  def cleanerActor: ActorRef

  private case class Schedule(task: Task)

  class Cleaner extends Actor with AtomActorLogging {
    private val scheduleReqId = ReqID("cleaner", "schedule")

    private case class DoClean(task: Task)

    override def receive = {
      case Schedule(task) =>
        context.system.scheduler.schedule(12 hours, 1 day, self, DoClean(task))
        logWithId.info(scheduleReqId, "Scheduled task {} for execution", task.name)

      case DoClean(task) =>
        val id = ReqID("cleaner", System.currentTimeMillis().toString)
        logWithId.info(id, "Executing task {}", task.name)
        task.block(id)
        logWithId.info(id, "Task {} executed", task.name)
    }
  }

  object Cleaner {
    def props = Props(classOf[Cleaner], component)
  }

  def scheduleCleaning(task: Task) {
    inPostInit(cleanerActor ! Schedule(task))
  }
}
