package ru.yandex.atom.periodic.clean

import ru.yandex.atom.data.ReqID
import java.io.File
import ru.yandex.atom.utils.log.AtomLogger

/**
 * @author avhaliullin
 */
case class Task(name: String, block: ReqID => Unit)

object Task {
  def cleanDir(log: AtomLogger, name: String, dir: String, predicate: File => Boolean): Task = Task(name, {
    id =>
      new File(dir).listFiles().foreach {
        file =>
          if (predicate(file)) {
            log.info(id, "Deleting file {}", file.getAbsolutePath)
            if (!file.delete()) {
              log.error(id, "Failed to delete {}", file.getAbsolutePath)
            }
          }
      }
  })
}