package ru.yandex.atom.frontend

import scala.concurrent.Future
import ru.yandex.atom.frontend.data.{UrlListIdView, UrlListsCollectionView, UrlListView}
import ru.yandex.atom.data.ReqID

/**
 * @author avhaliullin
 */
trait ViewerBackendProxyComponent {
  def viewerBackendProxy: ViewerBackendProxy

  trait ViewerBackendProxy {
    def readUrlsList(id: ReqID, userId: Long, listId: Long): Future[UrlListView]

    def listUrlListIds(id: ReqID, userId: Long): Future[UrlListsCollectionView]

    def createUrlList(id: ReqID, userId: Long, urls: Set[String]): Future[UrlListIdView]

    def updateUrlList(id: ReqID, userId: Long, listId: Long, urls: Set[String]): Future[Unit]
  }

}
