package ru.yandex.atom.frontend

import ru.yandex.atom.service.UrlListsActorComponent
import akka.pattern.ask
import ru.yandex.atom.error.ErrorUtils
import ru.yandex.atom.frontend.data.{UrlListIdView, UrlListsCollectionView, UrlListView}
import ru.yandex.atom.data.ReqID
import scala.concurrent.ExecutionContext.Implicits.global
import akka.util.Timeout
import concurrent.duration._
import language.postfixOps

/**
 * @author avhaliullin
 */
trait ViewerBackendProxyComponentImpl extends ViewerBackendProxyComponent {
  component: UrlListsActorComponent =>

  class ViewerBackendProxyImpl extends ViewerBackendProxy {

    import UrlListsRequest._
    import UrlListsResponse._

    implicit val to = Timeout(2 seconds)
    val bigTO = Timeout(5 seconds)

    def readUrlsList(id: ReqID, userId: Long, listId: Long) = {
      ErrorUtils.safeMapFutureMessage[UrlListsResponse, ViewUrlsResponse](urlListsActor ? ViewUrls(id, userId, listId)).map {
        resp =>
          UrlListView(resp.list.urls.toSeq.sorted)
      }
    }

    def listUrlListIds(id: ReqID, userId: Long) = {
      ErrorUtils.safeMapFutureMessage[UrlListsResponse, ListIdsResponse](urlListsActor ? ListIds(id, userId)).map {
        resp =>
          UrlListsCollectionView(resp.ids.toSeq.sorted)
      }
    }

    def createUrlList(id: ReqID, userId: Long, urls: Set[String]) = {
      ErrorUtils.safeMapFutureMessage[UrlListsResponse, CreateUrlsResponse](urlListsActor.ask(CreateUrls(id, userId, urls))(bigTO)).map {
        resp =>
          UrlListIdView(resp.listId)
      }
    }

    def updateUrlList(id: ReqID, userId: Long, listId: Long, urls: Set[String]) =
      ErrorUtils.safeMapFutureMessage[UrlListsResponse, UpdateUrlsResponse](urlListsActor.ask(UpdateUrls(id, userId, listId, urls))(bigTO)).map {
        resp =>
      }
  }

}
