package ru.yandex.atom.frontend.data.marshallers

import spray.json._
import ru.yandex.atom.frontend.data.{UrlListIdView, UrlListsCollectionView, UrlListView}

/**
 * @author avhaliullin
 */
object JsonMarshalling extends DefaultJsonProtocol {

  implicit object UrlListViewJsonWriter extends RootJsonWriter[UrlListView] {
    def write(obj: UrlListView) = JsObject("urls" -> JsArray(obj.urls.map(x => JsObject(Map(
      "original" -> JsString(x.originalUrl.toString),
      "normalized" -> JsString(x.normalizedUrl.toString)
    ))): _*))
  }

  implicit object UrlListsCollectionViewJsonWriter extends RootJsonWriter[UrlListsCollectionView] {
    def write(obj: UrlListsCollectionView) = JsObject("urlLists" -> JsArray(obj.ids.map {
      id =>
        JsObject("id" -> JsNumber(id))
    }: _*))
  }

  implicit object UrlListIdViewJsonWriter extends RootJsonWriter[UrlListIdView] {
    def write(obj: UrlListIdView) = JsObject("id" -> JsNumber(obj.id))
  }

}
