package ru.yandex.atom.frontend.directive

import org.slf4j.LoggerFactory
import ru.yandex.atom.data.ReqID
import ru.yandex.atom.utils.log.AtomLogger
import spray.http.{HttpResponse, RemoteAddress, StatusCodes}
import spray.routing.Directive1

/**
 * @author avhaliullin
 */
object CommonDirectives {
  private val actionLog = AtomLogger(LoggerFactory.getLogger("ActionResult"))
  private val ACTION_RESULT_LOGGING = "Action Result: status={} action={} timeMs={}"

  import spray.routing.directives.BasicDirectives._

  type ReqIdGenerator = () => ReqID

  def logReq(log: AtomLogger, gen: ReqIdGenerator, ip: RemoteAddress): Directive1[ReqID] = {
    extract(_ => gen()).flatMap {
      id =>
        mapRequestContext {
          ctx ⇒
            val reqString = ctx.request.method.name + " '" + ctx.request.uri.toRelative + "'"
            log.info(id, "Queried {} from {}", reqString, ip)
            val startTime = System.currentTimeMillis()
            ctx.withRouteResponseMapped {
              response =>
                val durationMs = System.currentTimeMillis() - startTime
                response match {
                  case r: HttpResponse =>
                    val code = r.status match {
                      case _: StatusCodes.ClientError => "USER_ERROR"
                      case _: StatusCodes.ServerError => "FAIL"
                      case _ => "SUCCESS"
                    }
                    actionLog.info(id, ACTION_RESULT_LOGGING, code, ctx.request.uri.path.toString, durationMs.toString)
                }
                log.info(id, "Processing time for request {} is {}ms", reqString, durationMs)
                response
            }
        }.hmap(_ => id)
    }
  }
}
