package ru.yandex.atom.service

import spray.routing.{AuthenticationFailedRejection, RequestContext}
import scala.concurrent.Future
import spray.http.HttpHeaders.Authorization
import spray.routing.AuthenticationFailedRejection.{CredentialsRejected, CredentialsMissing}
import ru.yandex.atom.data.ReqID
import spray.http.RemoteAddress

/**
 * @author avhaliullin
 */
trait AuthenticatorComponentDummyImpl extends AuthenticatorComponent {

  class AuthenticatorDummyImpl extends Authenticator {
    def auth(id: ReqID, ip: RemoteAddress, req: RequestContext) = {
      Future.successful(req.request.header[Authorization] match {
        case Some(header) =>
          try {
            val uid = header.credentials.value.toLong
            Right(uid)
          } catch {
            case e: NumberFormatException =>
              Left(AuthenticationFailedRejection(CredentialsRejected, List(header)))
          }
        case None =>
          Left(AuthenticationFailedRejection(CredentialsMissing, List()))
      })
    }
  }

}
