package ru.yandex.atom.service

import spray.routing.{AuthenticationFailedRejection, RequestContext}
import spray.http.HttpHeaders.Authorization
import spray.routing.AuthenticationFailedRejection.{CredentialsRejected, CredentialsMissing}
import scala.concurrent.ExecutionContext.Implicits.global
import concurrent._
import duration._
import akka.util.Timeout
import ru.yandex.atom.data.ReqID
import spray.http.RemoteAddress
import akka.pattern.ask
import ru.yandex.atom.error.ErrorUtils

/**
 * @author avhaliullin
 */
trait AuthenticatorComponentImpl extends AuthenticatorComponent {
  component: APIKeysActorComponent =>

  class AuthenticatorImpl extends Authenticator {

    def auth(id: ReqID, ip: RemoteAddress, req: RequestContext) = {
      implicit val timeout = Timeout(10 seconds)
      req.request.header[Authorization] match {
        case Some(header) =>
          ErrorUtils.safeMapFutureMessage[APIKeysResponse, APIKeysResponse.KeyChecked](apiKeysActor ? APIKeysRequest.CheckKey(id, header.credentials.value, ip)).map {
            msg =>
              msg.uid match {
                case Some(uid) => Right(uid)
                case None => Left(AuthenticationFailedRejection(CredentialsRejected, List(header)))
              }
          }
        case None =>
          Future.successful(Left(AuthenticationFailedRejection(CredentialsMissing, List())))
      }
    }
  }


}
