package ru.yandex.atom.viewer

import akka.actor.ActorSystem
import akka.routing.FromConfig
import org.slf4j.LoggerFactory
import ru.yandex.atom.application.SprayApplication
import ru.yandex.atom.db.cassandra.{CassandraActorComponentImpl, CassandraComponentImpl}
import ru.yandex.atom.frontend.{ViewerBackendProxyComponentImpl, ViewerRouterComponent}
import ru.yandex.atom.service._
import ru.yandex.atom.zookeeper.ZookeeperActorComponentImpl

import scala.language.postfixOps

/**
 * @author avhaliullin
 */
object Main extends SprayApplication
with CassandraComponentImpl
with CassandraActorComponentImpl
with GeminiActorBinaryComponentImpl
with ZookeeperActorComponentImpl
with IdGeneratorActorComponentImpl
with UrlListsActorComponentImpl
with UrlNormalizerActorComponentImpl
with ViewerRouterComponent
with ViewerBackendProxyComponentImpl
with APIKeysActorComponentImpl
with HardcodedKeysActorComponentImpl
with AuthenticatorComponentImpl {

  def configResource = "viewer"

  val log = LoggerFactory.getLogger(getClass)

  val actorSystem = ActorSystem("atom-viewer", config)

  val cassandra = new CassandraImpl(config("cassandra"))

  val authenticator = new AuthenticatorImpl

  val viewerBackendProxy = new ViewerBackendProxyImpl

  val realAPIKeysActor = actorSystem.actorOf(APIKeysActor.props(config("apiKeys")), "apiKeys-back")
  val apiKeysActor = actorSystem.actorOf(HardcodedKeysActor.props(realAPIKeysActor), "apiKeys-front")

  val geminiActor = actorSystem.actorOf(GeminiActor.props(config("gemini")), "gemini")

  val cassandraActor = actorSystem.actorOf(CassandraActor.props, "cassandra")

  val zookeeperActor = actorSystem.actorOf(ZookeeperActorImpl.props(config("zookeeper")), "zookeeper")

  val idGeneratorActor = actorSystem.actorOf(IdGeneratorActorImpl.props(config("idGenerator")), "id-generator")

  val urlNormalizerActor = actorSystem.actorOf(UrlNormalizer.props(config("urlNormalizer")), "url-normalizer")

  val urlListsActor = actorSystem.actorOf(UrlListsActorImpl.props(config("urlLists")), "url-lists")

  val httpRouter = actorSystem.actorOf(ViewerRouter.props.withRouter(FromConfig()), "http-handler")

}
