package ru.yandex.autodoc.common.doc;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.autodoc.common.doc.annotation.Name;

import java.lang.reflect.AnnotatedElement;

/**
 * @author avhaliullin
 */
public final class DocUtils {
    private DocUtils() {
    }

    public static String getCategoryForAnnotatedElement(AnnotatedElement elem) {
        Category category = elem.getAnnotation(Category.class);
        return category == null ? null : category.value();
    }

    public static String getCategoryForObject(Object obj) {
        return obj == null ? null : getCategoryForAnnotatedElement(obj.getClass());
    }

    public static String getDescriptionForAnnotatedElement(AnnotatedElement elem) {
        Description desc = elem.getAnnotation(Description.class);
        return desc == null ? null : desc.value();
    }

    public static String getDescriptionForObject(Object obj) {
        return obj == null ? null : getDescriptionForAnnotatedElement(obj.getClass());
    }

    public static String getNameForAnnotatedElement(AnnotatedElement elem) {
        Name desc = elem.getAnnotation(Name.class);
        return desc == null ? null : desc.value();
    }

    public static String getNameForObject(Object obj) {
        return obj == null ? null : getNameForAnnotatedElement(obj.getClass());
    }
}
