package ru.yandex.autodoc.common.doc;

import ru.yandex.autodoc.common.out.json.JsonValueWriter;

/**
 * @author avhaliullin
 */
public class ExtraInfoItem {
    private final String title;
    private final ExtraInfo content;

    private ExtraInfoItem(String title, ExtraInfo content) {
        this.title = title;
        this.content = content;
    }

    public String getTitle() {
        return title;
    }

    public ExtraInfo getContent() {
        return content;
    }

    public static ExtraInfoItem createSimple(String content) {
        return new ExtraInfoItem(null, new TextExtraInfo(content));
    }

    public static ExtraInfoItem createSpoiler(String title, ExtraInfo content) {
        return new ExtraInfoItem(title, content);
    }

    public static interface ExtraInfo {

    }

    public static class TextExtraInfo implements ExtraInfo {
        public final String info;

        public TextExtraInfo(String info) {
            this.info = info;
        }
    }

    public static class JsonExtraInfo implements ExtraInfo {
        public final JsonValueWriter info;

        public JsonExtraInfo(JsonValueWriter info) {
            this.info = info;
        }
    }

    public static ExtraInfo createTextInfo(String text) {
        return new TextExtraInfo(text);
    }

    public static ExtraInfo createJsonInfo(JsonValueWriter info) {
        return new JsonExtraInfo(info);
    }
}
