package ru.yandex.autodoc.common.doc;

import ru.yandex.autodoc.common.doc.abstracts.MethodDocumentation;
import ru.yandex.autodoc.common.doc.error.ErrorDescription;
import ru.yandex.autodoc.common.doc.params.ParamDescriptor;
import ru.yandex.autodoc.common.doc.result.MethodResult;
import ru.yandex.autodoc.common.doc.view.Markup;

import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class MethodDocumentationImpl implements MethodDocumentation {
    private final String name;
    private final boolean deprecated;
    private final boolean needAuthorization;
    private final String definedInContext;
    private final List<ErrorDescription> methodErrors;
    private final MethodResult methodResult;
    private final List<ParamDescriptor> paramDescriptors;
    private final String paramsStringDescription;
    private final String documentation;
    private final String category;
    private final Map<String, Markup> extraInfoBlocks;

    public MethodDocumentationImpl(String name, boolean deprecated, boolean needAuthorization, String definedInContext,
                                   List<ErrorDescription> methodErrors, MethodResult methodResult,
                                   List<ParamDescriptor> paramDescriptors, String paramsStringDescription,
                                   String documentation, String category, Map<String, Markup> extraInfoBlocks) {
        this.name = name;
        this.deprecated = deprecated;
        this.needAuthorization = needAuthorization;
        this.definedInContext = definedInContext;
        this.methodErrors = methodErrors;
        this.methodResult = methodResult;
        this.paramDescriptors = paramDescriptors;
        this.paramsStringDescription = paramsStringDescription;
        this.documentation = documentation;
        this.category = category;
        this.extraInfoBlocks = extraInfoBlocks;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isDeprecated() {
        return deprecated;
    }

    @Override
    public boolean needAuthorization() {
        return needAuthorization;
    }

    @Override
    public String definedInContext() {
        return definedInContext;
    }

    @Override
    public List<ErrorDescription> getMethodErrors() {
        return methodErrors;
    }

    @Override
    public MethodResult getMethodResult() {
        return methodResult;
    }

    @Override
    public List<ParamDescriptor> getParamDescriptors() {
        return paramDescriptors;
    }

    @Override
    public String getParamsStringDescription() {
        return paramsStringDescription;
    }

    @Override
    public String getDocumentation() {
        return documentation;
    }

    @Override
    public String getCategory() {
        return category;
    }

    @Override
    public Map<String, Markup> extraInfoBlocks() {
        return extraInfoBlocks;
    }
}
