package ru.yandex.autodoc.common.doc.error;

import ru.yandex.autodoc.common.doc.types.AnyObjectModel;
import ru.yandex.autodoc.common.out.json.JsonValueWriter;

/**
 * @author avhaliullin
 */
public class ErrorDescription {
    public final String problem;
    public final String description;
    public final JsonValueWriter jsonExample;
    public final AnyObjectModel model;

    @Deprecated
    public ErrorDescription(String problem, String description, JsonValueWriter jsonExample) {
        this(problem, description, jsonExample, null);
    }

    public ErrorDescription(String problem, String description, AnyObjectModel model) {
        this(problem, description, null, model);
    }

    private ErrorDescription(String problem, String description, JsonValueWriter jsonExample,
                             AnyObjectModel model) {
        this.problem = problem;
        this.description = description;
        this.jsonExample = jsonExample;
        this.model = model;
    }
}
