package ru.yandex.autodoc.common.doc.params;

import ru.yandex.autodoc.common.doc.ExtraInfoItem;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ParamDescriptor {
    private final String name;
    private final boolean required;
    private final ParamType type;
    private final String description;
    private final String defaultValue;
    private final List<ExtraInfoItem> extraInfos;

    public ParamDescriptor(String name, boolean required, ParamType type, String defaultValue, String description, List<ExtraInfoItem> extraInfos) {
        this.name = name;
        this.required = required;
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
        this.extraInfos = extraInfos;
    }

    public String getName() {
        return name;
    }

    public boolean isRequired() {
        return required;
    }

    public ParamType getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public List<ExtraInfoItem> getExtraInfos() {
        return extraInfos;
    }
}
