package ru.yandex.autodoc.common.doc.types;

import java.util.List;

/**
 * @author avhaliullin
 */
public class EnumType extends ValueType {
    private final List<Entry> entries;

    public EnumType(String name, List<Entry> entries) {
        super(name, STRING);
        this.entries = entries;
    }

    public List<Entry> getEntries() {
        return entries;
    }

    public static class Entry {
        private final String value;
        private final String description;

        public Entry(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public String getValue() {
            return value;
        }

        public String getDescription() {
            return description;
        }
    }
}
