package ru.yandex.autodoc.common.doc.types;

import java.util.List;

/**
 * @author avhaliullin
 */
public class PolyObjectModel extends AnyObjectModel {
    private final String discriminator;
    private final List<Case> cases;

    public PolyObjectModel(String name, String discriminator, List<Case> cases) {
        super(name, STRING);
        this.discriminator = discriminator;
        this.cases = cases;
    }

    public String getDiscriminator() {
        return discriminator;
    }

    public List<Case> getCases() {
        return cases;
    }

    public static class Case {
        private final String caseName;
        private final ObjectModel model;

        public Case(String caseName, ObjectModel model) {
            this.caseName = caseName;
            this.model = model;
        }

        public String getCaseName() {
            return caseName;
        }

        public ObjectModel getModel() {
            return model;
        }
    }
}
