package ru.yandex.autodoc.common.doc.types;

import ru.yandex.autodoc.common.doc.params.ParamType;

/**
 * @author avhaliullin
 */
public class ValueType extends ParamType {
    private final String name;
    private final ValueType baseType;

    public ValueType(String name, ValueType baseType) {
        super(name);
        this.name = name;
        this.baseType = baseType;
    }

    public String getName() {
        return name;
    }

    public ValueType getBaseType() {
        return baseType;
    }

    public static final Primitive STRING = new Primitive("string", null, "some string");
    public static final Primitive NUMERIC = new Primitive("numeric", STRING, "1");
    public static final Primitive INTEGER = new Primitive("integer", NUMERIC, "1");
    public static final Primitive INT8 = new Primitive("int8", INTEGER, "1");
    public static final Primitive INT16 = new Primitive("int16", INTEGER, "1");
    public static final Primitive INT32 = new Primitive("int32", INTEGER, "1");
    public static final Primitive INT64 = new Primitive("int64", INTEGER, "1");
    public static final Primitive FLOAT = new Primitive("float", NUMERIC, "1.1");
    public static final Primitive SINGLE = new Primitive("single", FLOAT, "1.1");
    public static final Primitive DOUBLE = new Primitive("double", FLOAT, "1.1");
    public static final Primitive BOOLEAN = new Primitive("boolean", STRING, "false");

    public static final ValueType COLLECTION = new ValueType("collection", STRING);

    public static class Primitive extends ValueType {
        private final String example;

        public Primitive(String name, ValueType baseType, String example) {
            super(name, baseType);
            this.example = example;
        }

        public String getExample() {
            return example;
        }
    }
}
