package ru.yandex.autodoc.common.doc.view;

import ru.yandex.autodoc.common.doc.DocumentationProvider;
import ru.yandex.autodoc.common.doc.view.common.MarkupRequestHandler;
import ru.yandex.autodoc.common.doc.view.common.Renderer;

import java.util.Map;

/**
 * @author avhaliullin
 */
public class DocumentationProviderImpl implements DocumentationProvider {
    private Renderer renderer;
    private MarkupRequestHandler handler;

    @Override
    public String provide(Map<String, String> params) {
        return renderer.render(handler.handle(params), params);
    }

    @Override
    public String getContentType() {
        return renderer.contentType();
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public void setHandler(MarkupRequestHandler handler) {
        this.handler = handler;
    }
}
