package ru.yandex.autodoc.common.doc.view.format;

import ru.yandex.autodoc.common.doc.view.Markup;

import java.util.List;

/**
 * @author avhaliullin
 */
public interface JsonValue {
    Markup getDescription();

    class JsonField {
        private final Markup key;
        private final JsonValue value;
        private final Markup description;

        public JsonField(Markup key, JsonValue value, Markup description) {
            this.key = key;
            this.value = value;
            this.description = description;
        }

        public Markup getKey() {
            return key;
        }

        public JsonValue getValue() {
            return value;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class PolyCase {
        private final String caseName;
        private final List<JsonField> fields;
        private final Markup description;

        public PolyCase(String caseName, List<JsonField> fields, Markup description) {
            this.caseName = caseName;
            this.fields = fields;
            this.description = description;
        }

        public String getCaseName() {
            return caseName;
        }

        public List<JsonField> getFields() {
            return fields;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class PolyObject implements JsonValue {
        private final String discriminator;
        private final List<PolyCase> cases;
        private final Markup description;

        public PolyObject(String discriminator, List<PolyCase> cases, Markup description) {
            this.discriminator = discriminator;
            this.cases = cases;
            this.description = description;
        }

        public String getDiscriminator() {
            return discriminator;
        }

        public List<PolyCase> getCases() {
            return cases;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class Object implements JsonValue {
        private final List<JsonField> fields;
        private final Markup description;
        private final boolean map;

        public Object(List<JsonField> fields, Markup description, boolean map) {
            this.fields = fields;
            this.description = description;
            this.map = map;
        }

        public List<JsonField> getFields() {
            return fields;
        }

        public Markup getDescription() {
            return description;
        }

        public boolean isMap() {
            return map;
        }
    }

    class Array implements JsonValue {
        private final JsonValue item;
        private final Markup description;

        public Array(JsonValue item, Markup description) {
            this.item = item;
            this.description = description;
        }

        public JsonValue getItem() {
            return item;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class StringValue implements JsonValue {
        private final Markup example;
        private final Markup description;

        public StringValue(Markup example, Markup description) {
            this.example = example;
            this.description = description;
        }

        public Markup getExample() {
            return example;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class BooleanValue implements JsonValue {
        private final boolean example;
        private final Markup description;

        public BooleanValue(boolean example, Markup description) {
            this.example = example;
            this.description = description;
        }

        public boolean getExample() {
            return example;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class IntValue implements JsonValue {
        private final int example;
        private final Markup description;

        public IntValue(int example, Markup description) {
            this.example = example;
            this.description = description;
        }

        public int getExample() {
            return example;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class FloatValue implements JsonValue {
        private final float example;
        private final Markup description;

        public FloatValue(float example, Markup description) {
            this.example = example;
            this.description = description;
        }

        public float getExample() {
            return example;
        }

        public Markup getDescription() {
            return description;
        }
    }


}
