package ru.yandex.autodoc.common.doc.view.format;

import ru.yandex.autodoc.common.doc.view.Markup;

import java.util.List;

/**
 * @author avhaliullin
 */
public interface XmlValue {
    interface XmlTag extends XmlValue {
        Markup getDescription();

        Markup getName();
    }

    class InlineTag implements XmlTag {
        private final Markup name;
        private final Markup value;
        private final Markup description;
        private final String baseType;

        public InlineTag(Markup name, Markup value, Markup description, String baseType) {
            this.name = name;
            this.value = value;
            this.description = description;
            this.baseType = baseType;
        }

        @Override
        public Markup getName() {
            return name;
        }

        public Markup getValue() {
            return value;
        }

        @Override
        public Markup getDescription() {
            return description;
        }

        public String getBaseType() {
            return baseType;
        }
    }

    class MultiLineTag implements XmlTag {
        private final Markup name;
        private final List<XmlValue> values;
        private final Markup description;

        public MultiLineTag(Markup name, List<XmlValue> values, Markup description) {
            this.name = name;
            this.values = values;
            this.description = description;
        }

        @Override
        public Markup getName() {
            return name;
        }

        public List<XmlValue> getValues() {
            return values;
        }

        @Override
        public Markup getDescription() {
            return description;
        }
    }

    class PolyCase {
        private final String caseName;
        private final List<XmlValue> values;
        private final Markup description;

        public PolyCase(String caseName, List<XmlValue> values, Markup description) {
            this.caseName = caseName;
            this.values = values;
            this.description = description;
        }

        public String getCaseName() {
            return caseName;
        }

        public List<XmlValue> getValues() {
            return values;
        }

        public Markup getDescription() {
            return description;
        }
    }

    class PolyObjectTag implements XmlTag {
        private final Markup name;
        private final String discriminator;
        private final List<PolyCase> cases;
        private final Markup description;

        public PolyObjectTag(Markup name, String discriminator, List<PolyCase> cases, Markup description) {
            this.name = name;
            this.discriminator = discriminator;
            this.cases = cases;
            this.description = description;
        }

        @Override
        public Markup getName() {
            return name;
        }

        public String getDiscriminator() {
            return discriminator;
        }

        public List<PolyCase> getCases() {
            return cases;
        }

        @Override
        public Markup getDescription() {
            return description;
        }
    }

    XmlValue CONTINUATION = new XmlValue() {};

    class Comment implements XmlValue {
        private final Markup comment;

        public Comment(Markup comment) {
            this.comment = comment;
        }

        public Markup getComment() {
            return comment;
        }
    }
}
