package ru.yandex.autodoc.common.doc.view.handlers;

import org.apache.commons.lang3.tuple.Pair;
import ru.yandex.autodoc.common.doc.types.AnyObjectModel;
import ru.yandex.autodoc.common.doc.view.Markup;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
public class MultiFormatResolver implements ObjectFormatResolver {
    public static MultiFormatResolver XML_JSON_INSTANCE = new MultiFormatResolver(Arrays.asList(
            Pair.of("JSON", JsonFormatResolver.INSTANCE),
            Pair.of("XML", XmlNoWrapArraysFormatResolver.INSTANCE)
    ));

    private final List<Pair<String, ObjectFormatResolver>> formats;

    public MultiFormatResolver(List<Pair<String, ObjectFormatResolver>> formats) {
        this.formats = formats;
    }

    @Override
    public Markup resolve(AnyObjectModel model) {
        return new Markup.Tabs(formats.stream()
                .map(p -> Pair.of(p.getLeft(), p.getRight().resolve(model)))
                .collect(Collectors.toList())
        );
    }
}
