package ru.yandex.autodoc.common.doc.view.handlers;

import ru.yandex.autodoc.common.doc.types.CollectionType;
import ru.yandex.autodoc.common.doc.view.Markup;
import ru.yandex.autodoc.common.doc.view.format.XmlValue;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class XmlNoWrapArraysFormatResolver extends AbstractXmlFormatResolver {
    public static final XmlNoWrapArraysFormatResolver INSTANCE = new XmlNoWrapArraysFormatResolver();

    @Override
    protected List<XmlValue> resolveCollection(Markup tagName, Markup itemName, CollectionType tpe) {
        List<XmlValue> result = new ArrayList<>();
        result.addAll(resolveValue(itemName, itemName, tpe.getElementType()));
        result.add(XmlValue.CONTINUATION);
        return result;
    }
}
