package ru.yandex.autodoc.common.doc.view.handlers;

import ru.yandex.autodoc.common.doc.types.CollectionType;
import ru.yandex.autodoc.common.doc.view.Markup;
import ru.yandex.autodoc.common.doc.view.format.XmlValue;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author avhaliullin
 */
public class XmlWrapArraysFormatResolver extends AbstractXmlFormatResolver {
    public static XmlWrapArraysFormatResolver INSTANCE = new XmlWrapArraysFormatResolver();
    @Override
    protected List<XmlValue> resolveCollection(Markup tagName, Markup itemName, CollectionType tpe) {
        List<XmlValue> items = new ArrayList<>();
        items.addAll(resolveValue(itemName, itemName, tpe.getElementType()));
        items.add(XmlValue.CONTINUATION);
        return Collections.singletonList(
                new XmlValue.MultiLineTag(
                        tagName,
                        items,
                        Markup.EMPTY
                )
        );
    }
}
