package ru.yandex.autodoc.common.doc.view.renderers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author avhaliullin
 */
public class CSSClass {
    private final Set<String> classes;

    public CSSClass(Set<String> classes) {
        this.classes = classes;
    }

    private String getAttributeValue() {
        return String.join(" ", classes);
    }

    public String getAttribute() {
        return classes.isEmpty() ? "" : " class=\"" + getAttributeValue() + "\"";
    }

    public CSSClass withPrefixes() {
        Set<String> newClasses = new HashSet<>();
        for (String clazz : classes) {
            newClasses.add(clazz);
            String[] parts = clazz.split("-");
            StringBuilder prefix = new StringBuilder();
            for (int i = 0; i < parts.length; i++) {
                if (prefix.length() > 0) {
                    prefix.append("-");
                }
                prefix.append(parts[i]);
                newClasses.add(prefix.toString());
            }
        }
        return new CSSClass(newClasses);
    }

    public CSSClass add(CSSClass clazz) {
        Set<String> newClasses = new HashSet<>(classes);
        newClasses.addAll(clazz.classes);
        return new CSSClass(newClasses);
    }

    public static CSSClass create(String... classes) {
        return new CSSClass(new HashSet<>(Arrays.asList(classes)));
    }

    public static final CSSClass EMPTY = new CSSClass(Collections.emptySet());
}
