package ru.yandex.autodoc.common.doc.view.renderers;

import ru.yandex.autodoc.common.doc.params.ParamType;
import ru.yandex.autodoc.common.doc.view.handlers.JsonFormatResolver;
import ru.yandex.autodoc.common.doc.view.handlers.TypeMarkupUtil;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
@Deprecated
public class EnumResolvingHtmlJSONAppendable extends HtmlJSONAppendable {
    private static final Pattern CLASS_DESC_PATTERN = Pattern.compile("\\$\\{description\\(([^)]+)\\)}");

    public EnumResolvingHtmlJSONAppendable(StringBuilder sb, HtmlRenderer.ElementContext ctx,
                                           boolean quoteEnabled) {
        super(sb, ctx, quoteEnabled);
    }

    private String renderEnum(ParamType.DocumentedEnum tpe, boolean forcePopup, String anchor) {
        if (forcePopup || tpe.universe.size() > 3 || tpe.universe.stream().anyMatch(e -> e.description != null)) {
            return inlineMarkup(TypeMarkupUtil.enumMarkup(tpe, tpe.getName(), anchor));
        } else {
            return inlineMarkup(TypeMarkupUtil.typeToMarkup(
                    JsonFormatResolver.INSTANCE,
                    ParamType.stringOneOf(tpe.universe.stream().map(e -> e.value).collect(Collectors.toList())),
                    tpe.getName()
            ));
        }
    }

    private Optional<String> parseAndRenderEnum(String text) {
        try {
            Matcher m = CLASS_DESC_PATTERN.matcher(text);
            if (m.find()) {
                String className = m.group(1);
                Class<?> clazz = getClass().getClassLoader().loadClass(className);
                if (!clazz.isEnum()) {
                    throw new RuntimeException("Non-enum classes are not supported here, found " + clazz.getCanonicalName());
                }
                ParamType.DocumentedEnum tpe = ParamType.enumForClass(clazz);
                return Optional.of(renderEnum(
                        tpe,
                        true,
                        tpe.universe.isEmpty() ? null : tpe.universe.get(0).value
                ));
            } else {
                return Optional.empty();
            }
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void printKey(String key) {
        Optional<String> renderedEnumOpt = parseAndRenderEnum(key);
        if (renderedEnumOpt.isPresent()) {
            startSpan("json-key");
            append("\"" + renderedEnumOpt.get() + "\"");
            endSpan();
        } else {
            super.printKey(key);
        }
    }

    @Override
    protected void printSingleLineCommentPart(String part) {
        super.printKey(parseAndRenderEnum(part).orElse(part));
    }
}
