package ru.yandex.autodoc.common.out.json.builder;

/**
 * @author avhaliullin
 */
public abstract class ContainerBuilder {
    protected final JsonAppendable appendable;

    protected State state = State.READY;

    ContainerBuilder(JsonAppendable appendable) {
        this.appendable = appendable;
    }

    // Yes, package private
    void focusReturn() {
        state = State.READY;
    }

    protected void assertState(State... states) {
        for (State s : states) {
            if (s == state) {
                return;
            }
        }
        throw new RuntimeException("Bad " + getClass().getSimpleName() + " state: " + state);
    }

    protected enum State {
        READY,
        FOCUS_LOOSE,
        CLOSED
    }
}
